/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.seq.impl;

import org.moltools.apps.probemaker.seq.Polymorphism;
import org.moltools.lib.seq.alphabet.DegenerateNucleotide;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

public class SNP
implements Polymorphism {
    protected DegenerateNucleotide snp;
    protected String description;

    public SNP(DegenerateNucleotide dn, String desc) {
        this.snp = dn;
        if (this.snp == null) {
            throw new IllegalArgumentException("Invalid DegenerateNucleotide");
        }
        this.description = desc;
    }

    public SNP(Nucleotide[] nts, String desc) {
        char[] symbols = new char[nts.length];
        for (int i = 0; i < symbols.length; ++i) {
            symbols[i] = nts[i].getChar();
        }
        byte type = nts[0].getType();
        this.snp = NucleotideSequenceHandler.getDegenerateNucleotide((char[])symbols, (byte)type);
        if (this.snp == null) {
            throw new IllegalArgumentException("Invalid variant combination");
        }
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public Object[] getVariants() {
        return this.snp.getPossible();
    }

    public int length() {
        return 1;
    }

    public int getStringIndexOf(int ntpos) {
        if (ntpos == 1) {
            return 0;
        }
        throw new IllegalArgumentException("Position out of range: " + ntpos);
    }

    public String seqString() {
        return String.valueOf(this.snp.getChar());
    }
}

