/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.db.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.apptools.textio.ObjectBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.EqualPredicate;
import org.apache.commons.collections.functors.TransformedPredicate;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.db.ChangeableIndexedSequenceDB;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.SequenceDBBuilder;
import org.moltools.lib.seq.db.impl.AbstractChangeableDefiniteSequenceDB;
import org.moltools.lib.utils.IDExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSequenceDB<T extends Sequence>
extends AbstractChangeableDefiniteSequenceDB<T>
implements ChangeableIndexedSequenceDB<T> {
    protected List<T> sequences;

    public static SequenceDBBuilder getDefaultBuilder() {
        SequenceDBBuilder builder = new SequenceDBBuilder(){

            public <S extends Sequence> ListSequenceDB<S> buildDB(Collection<Map<String, String>> maps, ObjectBuilder<S> sb) {
                ListSequenceDB<Sequence> db = new ListSequenceDB<Sequence>();
                Iterator<Map<String, String>> i = maps.iterator();
                while (i.hasNext()) {
                    db.addSequence((Sequence)sb.buildObject(i.next()));
                }
                return db;
            }
        };
        return builder;
    }

    public ListSequenceDB() {
        this.sequences = new ArrayList<T>();
    }

    public ListSequenceDB(Collection<? extends T> seqs) {
        this.sequences = new ArrayList<T>(seqs);
    }

    public ListSequenceDB(DefiniteSequenceDB<? extends T> db) {
        this(db.getSequenceCollection());
    }

    @Override
    public int size() {
        return this.sequences.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sequences.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.sequences.iterator();
    }

    public boolean containsSequence(T seq) {
        return this.sequences.contains(seq);
    }

    @Override
    public boolean addSequence(T seq) {
        boolean res = this.sequences.add(seq);
        this.fireChangeEvent();
        return res;
    }

    @Override
    public void addSequences(DefiniteSequenceDB<? extends T> db) {
        Iterator<T> i = db.iterator();
        while (i.hasNext()) {
            this.sequences.add(i.next());
        }
        this.fireChangeEvent();
    }

    @Override
    public void addSequences(Collection<? extends T> seqs) {
        Iterator<T> i = seqs.iterator();
        while (i.hasNext()) {
            this.sequences.add(i.next());
        }
        this.fireChangeEvent();
    }

    @Override
    public int indexOfSequence(T seq) {
        return this.sequences.indexOf(seq);
    }

    public boolean removeSequence(T seq) {
        boolean res = this.sequences.remove(seq);
        this.fireChangeEvent();
        return res;
    }

    @Override
    public void removeSequenceAt(int pos) {
        this.sequences.remove(pos);
        this.fireChangeEvent();
    }

    @Override
    public void addSequenceAt(int pos, T seq) {
        this.sequences.add(pos, seq);
        this.fireChangeEvent();
    }

    @Override
    public T getSequenceAt(int pos) {
        return (T)((Sequence)this.sequences.get(pos));
    }

    @Override
    public void clear() {
        this.sequences.clear();
        this.fireChangeEvent();
    }

    @Override
    public boolean removeSequenceByID(String id) {
        Iterator<T> i = this.iterator();
        while (i.hasNext()) {
            Sequence s = (Sequence)i.next();
            if (!s.getID().equals(id)) continue;
            i.remove();
            this.fireChangeEvent();
            return true;
        }
        return false;
    }

    @Override
    public T getSequenceByID(String id) {
        EqualPredicate equal = new EqualPredicate((Object)id);
        IDExtractor trans = IDExtractor.getInstance();
        TransformedPredicate tp = new TransformedPredicate((Transformer)trans, (Predicate)equal);
        return (T)((Sequence)CollectionUtils.find(this.sequences, (Predicate)tp));
    }

    @Override
    public List<T> getSequenceList() {
        return new ArrayList<T>(this.sequences);
    }

    @Override
    public Collection<T> getSequenceCollection() {
        return this.getSequenceList();
    }
}

