/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.moltools.lib.seq.ChangeableCompositeSequence;
import org.moltools.lib.seq.CompositeSequence;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.SequenceView;
import org.moltools.lib.seq.impl.SimpleChangeableNucleotideSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleChangeableCompositeSequence<T extends NucleotideSequence>
extends SimpleChangeableNucleotideSequence
implements CompositeSequence<T>,
SequenceView,
ChangeableCompositeSequence<T> {
    public static final String BLOCK_SEPARATOR_STRING = "|";
    protected List<T> seqs = new ArrayList<T>();

    protected SimpleChangeableCompositeSequence() {
        this("", 0, "");
    }

    public SimpleChangeableCompositeSequence(String id, byte type, String name) {
        super(id, "", type, name);
    }

    @Override
    public void addSequenceToEnd(T seq) {
        this.setSequence(this.seqString() + seq.seqString());
        this.seqs.add(seq);
    }

    @Override
    public void removeSequence(T seq) {
        this.seqs.remove(seq);
        this.composeSequence();
    }

    protected void composeSequence() {
        StringBuffer seq = new StringBuffer();
        for (NucleotideSequence s : this.seqs) {
            seq.append(s.seqString());
        }
        this.setSequence(seq.toString());
    }

    @Override
    public String getViewSequence() {
        StringBuffer view = new StringBuffer();
        if (!this.seqs.isEmpty()) {
            view.append(((NucleotideSequence)this.seqs.get(0)).seqString());
            for (int i = 1; i < this.seqs.size(); ++i) {
                view.append(BLOCK_SEPARATOR_STRING);
                view.append(((NucleotideSequence)this.seqs.get(i)).seqString());
            }
        }
        return view.toString();
    }

    @Override
    public String getViewName() {
        return this.getName();
    }

    @Override
    public List<T> getSequences() {
        return Collections.unmodifiableList(this.seqs);
    }

    @Override
    public int getSequenceCount() {
        return this.seqs.size();
    }

    @Override
    public T getSequence(int number) {
        return (T)((NucleotideSequence)this.seqs.get(number - 1));
    }

    @Override
    public int getStartOfSequence(int number) {
        if (number < 1 || number > this.getSequenceCount()) {
            throw new IllegalArgumentException("No such block (" + number + ")");
        }
        int currentpos = 1;
        for (int i = 1; i < number; ++i) {
            currentpos += this.getSequence(i).length();
        }
        return currentpos;
    }

    @Override
    public int getEndOfSequence(int number) {
        if (number < 1 || number > this.getSequenceCount()) {
            throw new IllegalArgumentException("No such block (" + number + ")");
        }
        int currentpos = 0;
        for (int i = 1; i <= number; ++i) {
            currentpos += this.getSequence(i).length();
        }
        return currentpos;
    }

    @Override
    public int getSequenceNumberAt(int pos) {
        if (pos < 1 || pos > this.length()) {
            throw new IllegalArgumentException("Position out of bounds: " + pos + "/" + this.length());
        }
        int currentpos = 0;
        for (int i = 1; i <= this.getSequenceCount(); ++i) {
            if (pos > (currentpos += this.getSequence(i).length())) continue;
            return i;
        }
        throw new IllegalArgumentException("Position not found: " + pos + "/" + this.length());
    }

    @Override
    public int getSequenceNumberOf(T s) {
        for (int i = 1; i <= this.getSequenceCount(); ++i) {
            if (s != this.seqs.get(i - 1)) continue;
            return i;
        }
        throw new IllegalArgumentException("Sequence is not a subsequence of " + this.getID() + ": " + s.getID());
    }
}

