/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.utils;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SequenceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceBuilderFactory {
    public static <T extends Sequence> SequenceBuilder<T> getDefaultBuilder(final Class<T> sequenceClass) throws SecurityException {
        Constructor<T> con;
        if (!Sequence.class.isAssignableFrom(sequenceClass)) {
            throw new IllegalArgumentException(sequenceClass.getName() + " is not a Sequence class");
        }
        Class[] parameters1 = new Class[]{String.class, String.class, String.class};
        Class[] parameters2 = new Class[]{String.class, String.class};
        try {
            con = sequenceClass.getConstructor(parameters1);
        }
        catch (NoSuchMethodException e1) {
            try {
                con = sequenceClass.getConstructor(parameters2);
            }
            catch (NoSuchMethodException e2) {
                throw new UnsupportedOperationException("No constructor available");
            }
        }
        final Constructor<T> con2 = con;
        return new SequenceBuilder<T>(){

            public T buildObject(Map<String, String> sequenceData) {
                String id = sequenceData.get("ID");
                String name = sequenceData.get("sequence.name");
                String sequence = sequenceData.get("sequence.seqstring");
                if (con2.getParameterTypes().length == 3) {
                    try {
                        return (Sequence)con2.newInstance(id, sequence, name);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Sequence of class " + sequenceClass.getName() + " could not be created", e);
                    }
                }
                try {
                    return (Sequence)con2.newInstance(id, sequence);
                }
                catch (Exception e) {
                    throw new RuntimeException("Sequence of class " + sequenceClass.getName() + " could not be created", e);
                }
            }
        };
    }
}

