/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyedMap<K, V>
implements Map<K, V> {
    protected Transformer transformer;
    protected Map<K, V> delegateMap;

    public KeyedMap(Transformer transformer) {
        this(transformer, new HashMap());
    }

    public KeyedMap(Transformer transformer, Map<K, V> delegateMap) {
        this.transformer = transformer;
        this.delegateMap = delegateMap;
    }

    public KeyedMap(Transformer transformer, Collection<V> values) {
        this(transformer);
        this.addAll(values);
    }

    public void addAll(Collection<V> values) {
        for (V v : values) {
            this.add(v);
        }
    }

    public void add(V value) {
        Object id = this.transformer.transform(value);
        this.put(id, value);
    }

    @Override
    public void clear() {
        this.delegateMap.clear();
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.delegateMap.containsKey(arg0);
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.delegateMap.containsValue(arg0);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegateMap.entrySet();
    }

    @Override
    public V get(Object arg0) {
        return this.delegateMap.get(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.delegateMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.delegateMap.keySet();
    }

    @Override
    public V put(K arg0, V arg1) {
        Object keyCheck = this.transformer.transform(arg1);
        if (arg0 == null) {
            return null;
        }
        if (!arg0.equals(keyCheck)) {
            throw new RuntimeException("Supplied key is different from generated key");
        }
        return this.delegateMap.put(arg0, arg1);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object arg0) {
        return this.delegateMap.remove(arg0);
    }

    @Override
    public int size() {
        return this.delegateMap.size();
    }

    @Override
    public Collection<V> values() {
        return this.delegateMap.values();
    }
}

