/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.disperse;

import edu.stanford.disperse.RunTarget;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.genefront.piecemaker.model.SelectorTarget;
import net.genefront.piecemaker.variation.VariationUtils;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.collections.Predicate;
import org.moltools.lib.seq.Region;
import org.moltools.lib.seq.impl.SimpleRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterVariations
extends RunTarget {
    public static final String MASTER_FILE_OPTION = "m";

    protected static Options createOptions() {
        Options options = new Options();
        Option masterOption = new Option(MASTER_FILE_OPTION, true, "Path to master variation file");
        masterOption.setArgName("master file");
        options.addOption(targetOption);
        options.addOption(masterOption);
        options.addOption(variationOption);
        options.addOption(helpOption);
        return options;
    }

    public FilterVariations() {
        super("filtervars", FilterVariations.createOptions());
    }

    public static void main(String[] args) {
        try {
            FilterVariations runner = new FilterVariations();
            if (runner.parseCommandLine(args)) {
                if (!runner.commandLine.hasOption("t")) {
                    FilterVariations.error("No target file specified");
                    runner.printHelp();
                    System.exit(1);
                }
                if (!runner.commandLine.hasOption(MASTER_FILE_OPTION)) {
                    FilterVariations.error("No master variation file specified");
                    runner.printHelp();
                    System.exit(1);
                }
                File filteredfile = null;
                if (runner.commandLine.hasOption("v")) {
                    filteredfile = new File(runner.commandLine.getOptionValue("v"));
                }
                File targetfile = new File(runner.commandLine.getOptionValue("t"));
                File masterfile = new File(runner.commandLine.getOptionValue(MASTER_FILE_OPTION));
                if (!targetfile.canRead()) {
                    FilterVariations.error("Target file does not exist: " + targetfile.getAbsolutePath());
                    System.exit(1);
                }
                if (!masterfile.canRead()) {
                    FilterVariations.error("Master variation file does not exist: " + masterfile.getAbsolutePath());
                    System.exit(1);
                }
                if (filteredfile != null && !filteredfile.getAbsoluteFile().getParentFile().canWrite()) {
                    FilterVariations.error("Variation output file can not be written: " + filteredfile.getAbsolutePath());
                    System.exit(1);
                }
                Collection<SelectorTarget> targets = runner.readTargets(targetfile);
                System.out.println("Filtering variations from " + masterfile.getAbsolutePath());
                System.out.println("Filtering for " + targets.size() + " regions from " + targetfile.getAbsolutePath());
                System.out.println("Creating filter");
                HashMap<String, Collection<? extends Region>> filterMap = new HashMap<String, Collection<? extends Region>>(FilterVariations.createFilterMap(targets));
                RecordInRegionsPredicate recordPredicate = new RecordInRegionsPredicate(filterMap);
                System.out.println("Filtering");
                OutputStreamWriter writer = filteredfile != null ? new FileWriter(filteredfile) : new OutputStreamWriter(System.out);
                VariationUtils.filterVariationRecords((Reader)new FileReader(masterfile), (Writer)writer, (Predicate)recordPredicate);
                ((Writer)writer).close();
                System.out.println("Completed");
            }
        }
        catch (Exception exp) {
            FilterVariations.error(exp.getMessage(), exp);
            System.exit(1);
        }
    }

    static Map<String, Collection<Region>> createFilterMap(Collection<SelectorTarget> targets) {
        HashMap<String, Collection<Region>> filterMap = new HashMap<String, Collection<Region>>();
        for (SelectorTarget target : targets) {
            String parentID = target.getParentID();
            int start = target.getStart();
            int end = target.getEnd();
            HashSet<SimpleRegion> regions = (HashSet<SimpleRegion>)filterMap.get(parentID);
            if (regions == null) {
                regions = new HashSet<SimpleRegion>();
                filterMap.put(parentID, regions);
            }
            SimpleRegion r = new SimpleRegion(start, end);
            regions.add(r);
        }
        return filterMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RecordInRegionsPredicate
    implements Predicate {
        private Map<String, Collection<? extends Region>> filterMap;

        public RecordInRegionsPredicate(Map<String, Collection<? extends Region>> filterMap) {
            this.filterMap = filterMap;
        }

        public boolean evaluate(Object object) {
            String[] record = (String[])object;
            Collection<? extends Region> regions = this.filterMap.get(record[1]);
            if (regions == null) {
                return false;
            }
            int low = Integer.parseInt(record[2]);
            int high = Integer.parseInt(record[3]);
            for (Region region : regions) {
                if (low >= region.getEnd() || high <= region.getStart()) continue;
                return true;
            }
            return false;
        }
    }
}

