/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.task.AbstractTask;
import net.sf.apptools.utils.HTMLLogWriter;
import org.moltools.apps.probemaker.CoreMessages;
import org.moltools.apps.probemaker.ProbeMakerPlugIn;
import org.moltools.apps.probemaker.design.Analyzer;
import org.moltools.apps.probemaker.design.CandidateAnalysisModule;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.modules.ProbeAnalysisModule;
import org.moltools.apps.probemaker.project.Project;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.calc.ApproximateMeltingPointCalculator;
import org.moltools.design.calc.MeltingPointCalculator;
import org.moltools.design.calc.NNMeltingPointCalculator;
import org.moltools.design.data.PropertyAcceptorNucleotideSequence;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.utils.ParameterHolder;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.db.DefiniteSequenceDB;

public class ProbeAnalysisTask
extends AbstractTask {
    static Class<?> tagAllocatorClass;
    protected TagAllocator pd;
    protected DefiniteSequenceDB<Probe> probes;
    protected long startTime;
    protected long elapsedTime;
    protected Project project;
    protected Analyzer analyzer;
    protected MeltingPointCalculator defaultMpc;
    protected MeltingPointCalculator backupMpc;

    public ProbeAnalysisTask(Project proj, ErrorHandler ecb) throws InstantiationException, IllegalAccessException {
        super(CoreMessages.getString("ProbeAnalysisTask.TITLE_ANALYZING_PROBES"), 0, proj.getProbes().size(), 1, ecb);
        this.project = proj;
        this.probes = this.project.getProbes();
        this.analyzer = new Analyzer(this.project.getSettings(), null, null);
        try {
            this.defaultMpc = new NNMeltingPointCalculator();
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not initialize melting point calculator: " + ex.getMessage());
        }
        this.backupMpc = new ApproximateMeltingPointCalculator();
        if (this.defaultMpc instanceof ParameterHolder) {
            ((ParameterHolder)this.defaultMpc).addParameters(this.project.getSettings().getDesignParameters());
        }
        if (this.backupMpc instanceof ParameterHolder) {
            ((ParameterHolder)this.backupMpc).addParameters(this.project.getSettings().getDesignParameters());
        }
        this.pd = (TagAllocator)ProbeMakerPlugIn.defaultTagAllocatorClass.newInstance();
        this.pd.setup(this.project, this.analyzer, new HTMLLogWriter(null));
        this.setStatus(CoreMessages.getString("ProbeAnalysisTask.MESSAGE_READY"), 0);
        this.startTime = 0L;
        this.elapsedTime = 0L;
    }

    public void abort() {
        super.abort();
        this.elapsedTime = new Date().getTime() - this.startTime;
    }

    public long getTotalTime() {
        return this.elapsedTime;
    }

    public void run() {
        this.startTime = new Date().getTime();
        for (CandidateAnalysisModule m : this.project.getSettings().getArmModules()) {
            if (m instanceof ProbeAnalysisModule) {
                ((ProbeAnalysisModule)m).reset(this.pd, this.probes);
                continue;
            }
            m.reset();
        }
        for (CandidateAnalysisModule m : this.project.getSettings().getCandidateModulesStage1()) {
            if (m instanceof ProbeAnalysisModule) {
                ((ProbeAnalysisModule)m).reset(this.pd, this.probes);
                continue;
            }
            m.reset();
        }
        for (CandidateAnalysisModule m : this.project.getSettings().getCandidateModulesStage2()) {
            if (m instanceof ProbeAnalysisModule) {
                ((ProbeAnalysisModule)m).reset(this.pd, this.probes);
                continue;
            }
            m.reset();
        }
        Iterator pi = this.probes.iterator();
        while (pi.hasNext()) {
            if (this.isAborted()) {
                return;
            }
            try {
                Probe p = (Probe)pi.next();
                this.setStatus(CoreMessages.getString("ProbeAnalysisTask.MESSAGE_ANALYZING") + p.getName(), 0);
                this.reAnalyzeProbe(p);
                this.increaseProgress();
            }
            catch (Exception ex) {
                this.handleError(ex);
            }
        }
        for (Probe p : this.probes) {
            Analyzer.calculateAndSetQuality(p);
        }
        this.elapsedTime = new Date().getTime() - this.startTime;
        this.setCompleted();
    }

    short reAnalyzeProbe(Probe p) {
        ProbeMakerPropertyUtils.clearMessages((PropertyAcceptor)p);
        ProbeMakerPropertyUtils.clearMessages((PropertyAcceptor)p.getTSSPair());
        try {
            ProbeMakerPropertyUtils.clearMessages((PropertyAcceptor)((PropertyAcceptorNucleotideSequence)p.getTSSPair().getSequence("FIVE_PRIME")));
        }
        catch (ClusterException e) {
            // empty catch block
        }
        try {
            ProbeMakerPropertyUtils.clearMessages((PropertyAcceptor)((PropertyAcceptorNucleotideSequence)p.getTSSPair().getSequence("THREE_PRIME")));
        }
        catch (ClusterException clusterException) {
            // empty catch block
        }
        Analyzer.calculateArmTemperatures(p.getTSSPair(), this.defaultMpc, this.backupMpc);
        Analyzer.analyzeProbe(p, this.project.getSettings().getArmModules(), this.pd, this.probes);
        Analyzer.analyzeProbe(p, this.project.getSettings().getCandidateModulesStage1(), this.pd, this.probes);
        Analyzer.analyzeProbe(p, this.project.getSettings().getCandidateModulesStage2(), this.pd, this.probes);
        return Analyzer.calculateAndSetQuality(p);
    }
}

