/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Properties;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.task.AbstractTask;
import net.sf.apptools.task.ProgressListener;
import net.sf.apptools.task.ProgressModel;
import net.sf.apptools.utils.HTMLLogWriter;
import org.moltools.apps.probemaker.CoreMessages;
import org.moltools.apps.probemaker.design.Analyzer;
import org.moltools.apps.probemaker.design.DefaultNamingScheme;
import org.moltools.apps.probemaker.design.NamingScheme;
import org.moltools.apps.probemaker.design.ProbeAcceptor;
import org.moltools.apps.probemaker.design.ProbeDesigner;
import org.moltools.apps.probemaker.design.ProbeSelector;
import org.moltools.apps.probemaker.design.TSSConstructor;
import org.moltools.apps.probemaker.project.Project;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.design.data.Target;
import org.moltools.design.data.ValidatingTarget;
import org.moltools.lib.seq.db.ChangeableSequenceDB;
import org.moltools.lib.seq.db.DefiniteSequenceDB;

public class ProbeDesignTask
extends AbstractTask
implements ProgressListener {
    public boolean timing = false;
    public boolean verbose = false;
    public boolean screentags = false;
    protected DefiniteSequenceDB<ProbeMakerTarget> targets;
    protected ChangeableSequenceDB<Probe> probes;
    protected boolean appendProbes;
    protected NamingScheme namer = new DefaultNamingScheme();
    protected Project project;
    protected HTMLLogWriter log;
    ProbeDesigner designer;

    public ProbeDesignTask(Project proj, File logPath, ProbeAcceptor acc, ProbeSelector sel, ProbeDesigner designer, TSSConstructor con, ErrorHandler ecb) {
        super(MessageFormat.format(CoreMessages.getString("ProbeDesignTask.TITLE_DESIGN_TASK"), new Integer(proj.getTargets().size())), 0, proj.getTargets().size(), 2, ecb);
        this.project = proj;
        this.targets = this.project.getTargets();
        this.probes = this.project.getProbes();
        String date = DateFormat.getDateInstance(3).format(new Date());
        String logFilePrefix = date.replace('/', '-');
        logFilePrefix = logFilePrefix.replace('\\', '-');
        logFilePrefix = logFilePrefix.replace('.', '_');
        String logFileSuffix = ".log.html";
        File logFile = null;
        int suffixnumber = 0;
        if (logPath == null) {
            this.log = new HTMLLogWriter(null);
        } else {
            HTMLLogWriter defaultLog;
            this.log = defaultLog = new HTMLLogWriter(new PrintWriter(System.out));
            while ((logFile = new File(logPath, logFilePrefix + "_" + ++suffixnumber + logFileSuffix)).exists()) {
            }
            try {
                this.log = new HTMLLogWriter(new PrintWriter(new FileOutputStream(logFile)));
            }
            catch (FileNotFoundException fnfx) {
                fnfx.printStackTrace();
                this.log = defaultLog;
            }
        }
        Analyzer analyzer = new Analyzer(this.project.getSettings(), acc, sel);
        this.log.begin(this.project.getName(), logFile == null ? "" : logFile.getName(), new Date());
        this.log.printLineAndHeader("Design parameters");
        Properties props = new Properties();
        props.putAll(this.project.getSettings().getDesignParameters());
        this.log.printParameters(props);
        this.project.getTagAllocationTable().setSpacerSettings(this.project.getSettings().getDesignParameters());
        this.designer = designer;
        designer.setup(this.project, analyzer, con, this.namer, this.log, ecb);
    }

    public void abort() {
        if (!this.isAborted()) {
            super.abort();
            this.designer.abort();
            for (Probe p : this.probes) {
                Analyzer.calculateAndSetQuality(p);
            }
        }
        this.log.end();
    }

    public long getTotalTime() {
        return this.designer.getElapsedTime();
    }

    public long getCandidatesGenerated() {
        return this.designer.getCombinationsTried();
    }

    void setStatus(String s) {
        this.setStatus(s, 0);
    }

    public void run() {
        boolean done = false;
        try {
            this.log.printLineAndHeader("Validating targets");
            this.setStatus(CoreMessages.getString("ProbeDesignTask.MESSAGE_VALIDATING"));
            block7: for (Target target : this.targets) {
                if (!(target instanceof ValidatingTarget)) continue;
                ValidatingTarget vt = (ValidatingTarget)target;
                switch (vt.isValidTarget()) {
                    case 0: {
                        continue block7;
                    }
                    case 1: {
                        throw new UnsupportedOperationException(target.getID() + CoreMessages.getString("ProbeDesignTask.MESSAGE_INVALID"));
                    }
                    case 2: {
                        throw new UnsupportedOperationException(target.getID() + CoreMessages.getString("ProbeDesignTask.MESSAGE_NO_VARIANT"));
                    }
                }
                throw new IllegalArgumentException("Unexpected result from Target.isValidTarget()");
            }
            this.setStatus("Designing probes");
            this.designer.addListener(this);
            done = this.designer.start();
            this.designer.removeListener(this);
        }
        catch (Throwable t) {
            this.handleError(t);
        }
        this.log.end();
        if (done) {
            this.setCompleted();
        }
    }

    protected void handleError(Throwable t) {
        this.log.printLine("A problem occurred");
        this.log.printError(t.getMessage());
        super.handleError(t);
    }

    public void progressChanged(ProgressModel source, int newProgress) {
        this.fireProgressChange(newProgress);
    }

    public void statusChanged(ProgressModel source, int level, String status) {
        this.fireStatusChange(1, status);
    }

    public void taskCompleted(ProgressModel source) {
    }

    public void taskAborted(ProgressModel source) {
    }
}

