/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.ui.PlatformUI;
import org.moltools.apps.probemaker.CoreMessages;
import org.moltools.lib.seq.SequenceFormatException;

class TargetInputErrorCallback
implements ErrorHandler {
    Logger errlog;
    PlatformUI parent;

    public TargetInputErrorCallback(PlatformUI ui, Logger errlog) {
        this.errlog = errlog;
        this.parent = ui;
    }

    public boolean respondToError(String message, Throwable ex) {
        this.handleError(message, ex);
        return !(ex instanceof SequenceFormatException);
    }

    public void handleError(String message, Throwable ex) {
        this.errlog.log(Level.SEVERE, "Error during target IO", ex);
        if (ex instanceof SequenceFormatException) {
            this.parent.sendMessage(ex.toString(), CoreMessages.getString("ProbeMakerPlugIn.TITLE_LOAD_TARGETS"), (byte)0);
        } else if (ex instanceof FileNotFoundException) {
            this.parent.sendMessage(CoreMessages.getString("Common.MESSAGE_FILE_NOT_FOUND"), CoreMessages.getString("ProbeMakerPlugIn.TITLE_LOAD_TARGETS"), (byte)0);
        } else if (ex instanceof IOException) {
            this.parent.sendMessage(CoreMessages.getString("Common.MESSAGE_FILE_READ_ERROR"), CoreMessages.getString("ProbeMakerPlugIn.TITLE_LOAD_TARGETS"), (byte)0);
        } else {
            this.parent.sendMessage(CoreMessages.getString("ProbeMakerPlugIn.MESSAGE_ERROR_FILE_IO_FORMAT"), CoreMessages.getString("ProbeMakerPlugIn.TITLE_LOAD_TARGETS"), (byte)0);
        }
    }
}

