/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.design;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.task.ProgressListener;
import net.sf.apptools.task.ProgressModel;
import net.sf.apptools.utils.HTMLLogWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.moltools.apps.probemaker.CoreMessages;
import org.moltools.apps.probemaker.design.Analyzer;
import org.moltools.apps.probemaker.design.DefaultTSSPairDesigner;
import org.moltools.apps.probemaker.design.NamingScheme;
import org.moltools.apps.probemaker.design.ProbeDesigner;
import org.moltools.apps.probemaker.design.ProbeGroup;
import org.moltools.apps.probemaker.design.TSSConstructor;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.project.Project;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerSequenceFactory;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.apps.probemaker.seq.impl.TSSPair;
import org.moltools.design.data.Target;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.db.ChangeableIndexedSequenceDB;
import org.moltools.lib.seq.db.impl.ListSequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProbeDesigner
extends AbstractParameterHolder
implements ProbeDesigner {
    Project project;
    TSSConstructor constructor;
    TagAllocator allocator;
    ErrorHandler handler;
    NamingScheme namer;
    HTMLLogWriter log;
    DefaultTSSPairDesigner td;
    static Log logger = LogFactory.getLog(DefaultProbeDesigner.class);
    public static final Map<String, String> defaultParameters = new HashMap<String, String>();
    long startTime;
    long elapsedTime = -1L;
    private boolean aborted = false;
    List<ProgressListener> listeners = new ArrayList<ProgressListener>();

    public Map<String, String> getDefaultParameters() {
        return defaultParameters;
    }

    public DefaultProbeDesigner(TagAllocator ta) {
        this.allocator = ta;
    }

    @Override
    public void setup(Project p, Analyzer analyzer, TSSConstructor con, NamingScheme ns, HTMLLogWriter log, ErrorHandler ecb) {
        this.project = p;
        this.handler = ecb;
        this.namer = ns;
        this.log = log;
        Map<String, String> params = p.getSettings().getDesignParameters();
        this.constructor = con;
        this.constructor.addParameters(params);
        this.td = new DefaultTSSPairDesigner(this.constructor);
        this.td.setProject(this.project);
        this.td.setLog(log);
        this.allocator.setup(this.project, analyzer, log);
        this.addParameters(params);
    }

    private boolean aborted() {
        return this.aborted;
    }

    @Override
    public boolean start() {
        int progress = 0;
        this.startTime = System.currentTimeMillis();
        ChangeableIndexedSequenceDB<ProbeMakerTarget> targets = this.project.getTargets();
        ChangeableIndexedSequenceDB<Probe> probes = this.project.getProbes();
        this.log.printLineAndHeader("Designing target-specific sequences");
        this.fireStatusChange(0, CoreMessages.getString("ProbeDesignTask.MESSAGE_DESIGNING_TSS"));
        TSSPair[] pairs = new TSSPair[targets.size()];
        int tindex = 0;
        Iterator ti = targets.iterator();
        while (ti.hasNext() && !this.aborted()) {
            logger.info((Object)("Designing TSSs for target " + (tindex + 1)));
            ProbeMakerTarget target = (ProbeMakerTarget)ti.next();
            try {
                pairs[tindex] = this.td.designTSSPair(target);
            }
            catch (Exception ex) {
                this.log.printLine("A problem occurred");
                this.log.printError(ex.getMessage());
                this.handler.handleError(ex.toString(), (Throwable)ex);
            }
            ++tindex;
        }
        this.fireStatusChange(0, "Creating probes");
        ListSequenceDB newProbes = new ListSequenceDB();
        tindex = 0;
        Iterator ti2 = targets.iterator();
        while (ti2.hasNext()) {
            if (this.aborted()) {
                return false;
            }
            ProbeMakerTarget target = (ProbeMakerTarget)ti2.next();
            try {
                logger.info((Object)("Creating probe for " + target.getID()));
                byte probeAcidType = Byte.parseByte((String)this.parameters.get("PROBE_ACID_TYPE"));
                int up = Integer.parseInt((String)this.parameters.get("UPSTREAM_BLOCKS"));
                int down = Integer.parseInt((String)this.parameters.get("DOWNSTREAM_BLOCKS"));
                Probe p = ProbeMakerSequenceFactory.createProbeSkeleton(pairs[tindex], probeAcidType, up, down, probes);
                p.setName(this.namer.getProbeName(this.project, (Target)target));
                p.setID(this.namer.getProbeID(this.project, (Target)target));
                probes.addSequence((Sequence)p);
                newProbes.addSequence((Sequence)p);
            }
            catch (Exception ex) {
                this.log.printLine("A problem occurred");
                this.log.printError(ex.getMessage());
                this.handler.handleError(ex.toString(), (Throwable)ex);
            }
            ++tindex;
        }
        ArrayList<Object> newGroupsAndProbes = new ArrayList<Object>();
        for (Probe pr : newProbes) {
            ProbeGroup pg = (ProbeGroup)DesignUtils.getGroupWithType((PropertyHolder)pr, (String)"probeGroup");
            if (pg == null) {
                newGroupsAndProbes.add(pr);
                continue;
            }
            if (newGroupsAndProbes.contains((Object)pg)) continue;
            newGroupsAndProbes.add((Object)pg);
        }
        this.fireStatusChange(0, CoreMessages.getString("ProbeDesignTask.MESSAGE_ALLOCATING_TAGS"));
        int groupindex = 0;
        Iterator gi = newGroupsAndProbes.iterator();
        while (gi.hasNext()) {
            if (this.aborted()) {
                return false;
            }
            logger.info((Object)("Designing probes for group " + ++groupindex));
            try {
                Object o = gi.next();
                if (o instanceof ProbeGroup) {
                    ProbeGroup pg = (ProbeGroup)((Object)o);
                    this.fireStatusChange(0, "Group " + groupindex);
                    this.allocator.allocateTagsToGroup(pg);
                    Iterator pi = pg.getMembers().iterator();
                    while (pi.hasNext()) {
                        this.allocator.confirm((Probe)pi.next());
                        this.fireProgressChange(++progress);
                    }
                    continue;
                }
                Probe p = (Probe)o;
                ProbeGroup pg = new ProbeGroup(null, "DUMMY");
                pg.addMember(p);
                this.fireStatusChange(0, "Group " + groupindex);
                this.allocator.allocateTagsToGroup(pg);
                Iterator pi = pg.getMembers().iterator();
                while (pi.hasNext()) {
                    this.allocator.confirm((Probe)pi.next());
                    this.fireProgressChange(++progress);
                }
                pg.removeMember(p);
            }
            catch (Exception ex) {
                this.log.printLine("A problem occurred");
                this.log.printError(ex.getMessage());
                this.handler.handleError(ex.toString(), (Throwable)ex);
            }
        }
        Iterator i = probes.iterator();
        while (i.hasNext()) {
            if (this.aborted()) {
                return false;
            }
            Probe p = (Probe)i.next();
            Analyzer.calculateAndSetQuality(p);
        }
        this.elapsedTime = System.currentTimeMillis() - this.startTime;
        return true;
    }

    @Override
    public void abort() {
        this.aborted = true;
        this.allocator.abort();
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime < 0L ? System.currentTimeMillis() - this.startTime : this.elapsedTime;
    }

    @Override
    public long getCombinationsTried() {
        return this.allocator.getCandidateCount();
    }

    public void addListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }

    protected void fireProgressChange(int newProgress) {
        Iterator<ProgressListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().progressChanged((ProgressModel)this, newProgress);
        }
    }

    protected void fireStatusChange(int level, String status) {
        Iterator<ProgressListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().statusChanged((ProgressModel)this, level, status);
        }
    }

    protected void fireAborted() {
        Iterator<ProgressListener> i = new ArrayList<ProgressListener>(this.listeners).iterator();
        while (i.hasNext()) {
            i.next().taskAborted((ProgressModel)this);
        }
    }

    protected void fireCompleted() {
        Iterator<ProgressListener> i = new ArrayList<ProgressListener>(this.listeners).iterator();
        while (i.hasNext()) {
            i.next().taskCompleted((ProgressModel)this);
        }
    }

    public int getMaxProgress() {
        return this.project.getTargets().size();
    }

    public String getTitle() {
        return "Designing probes";
    }

    public int getStatusLevels() {
        return 1;
    }

    public int getMinProgress() {
        return 0;
    }

    public TagAllocator getTagAllocator() {
        return this.allocator;
    }

    static {
        defaultParameters.put("UPSTREAM_BLOCKS", "0");
        defaultParameters.put("DOWNSTREAM_BLOCKS", "0");
        defaultParameters.put("PROBE_ACID_TYPE", String.valueOf(0));
    }
}

