/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.apptools.Platform;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.plugin.PlugInFileWriter;
import net.sf.apptools.plugin.PlugInLoader;
import net.sf.apptools.plugin.PlugInManager;
import net.sf.apptools.ui.swing.SwingUITexts;
import net.sf.apptools.ui.swing.plugin.PlugInListView;
import net.sf.apptools.ui.swing.utils.ListMultiComponentDialog;

public class PlugInManagerDialog
extends ListMultiComponentDialog {
    private static final long serialVersionUID = 1L;
    JButton loadButton;
    JButton saveButton;
    PlugInManager manager;
    PlugInLoader loader;
    Platform platform;
    File store;

    public PlugInManagerDialog(Platform pf, Frame f, PlugInManager mgr, PlugInLoader loader, File store) {
        super(f, SwingUITexts.getString("PlugInManagerDialog.TITLE_PLUG_IN_EXTENSIONS"), null, null);
        try {
            this.platform = pf;
            this.manager = mgr;
            this.loader = loader;
            this.store = store;
            String[] identifiers = this.manager.getIdentifiers();
            Collection[] listArray = new Collection[identifiers.length];
            for (int i = 0; i < listArray.length; ++i) {
                try {
                    listArray[i] = this.manager.getPlugInList(identifiers[i]);
                    continue;
                }
                catch (PlugInException e) {
                    listArray[i] = new ArrayList();
                }
            }
            this.loadButton = new JButton(SwingUITexts.getString("PlugInManagerDialog.CAPTION_LOAD_PLUG_INS"));
            this.saveButton = new JButton(SwingUITexts.getString("PlugInManagerDialog.CAPTION_SAVE_PLUG_IN_LIST"));
            this.okButton.setToolTipText(SwingUITexts.getString("PlugInManagerDialog.TOOL_TIP_EXIT"));
            this.loadButton.addActionListener(this);
            this.loadButton.setToolTipText(SwingUITexts.getString("PlugInManagerDialog.TOOL_TIP_LOAD_PLUG_INS"));
            this.saveButton.addActionListener(this);
            this.saveButton.setToolTipText(SwingUITexts.getString("PlugInManagerDialog.TOOL_TIP_SAVE_PLUG_IN_LIST"));
            this.controlPane.add((Component)this.saveButton, 0);
            this.controlPane.add(Box.createHorizontalStrut(5), 0);
            this.controlPane.add((Component)this.loadButton, 0);
            Component[] components = new JComponent[listArray.length];
            for (int i = 0; i < components.length; ++i) {
                String desc;
                PlugInListView c = new PlugInListView(this.manager, identifiers[i]);
                JPanel p = new JPanel(new BorderLayout());
                p.add(c);
                try {
                    desc = this.manager.getPlugInDescription(identifiers[i]);
                }
                catch (PlugInException e) {
                    desc = "Plug-in type not registered";
                }
                p.setName(desc);
                components[i] = p;
            }
            JPanel protP = new JPanel();
            protP.add(new JScrollPane(new JList()));
            JPanel prototype = new JPanel();
            prototype.setPreferredSize(protP.getPreferredSize());
            this.setupComponents(components, prototype);
            this.pack();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            List messages;
            if (e.getSource() == this.okButton) {
                this.dispose();
            } else if (e.getSource() == this.saveButton) {
                try {
                    FileOutputStream fos = new FileOutputStream(this.store);
                    this.manager.storePlugIns((PlugInFileWriter)new PlugInFileWriter.DefaultFileWriter(), (OutputStream)fos);
                    fos.close();
                }
                catch (Exception ex) {
                    this.platform.handleError(SwingUITexts.getString("PlugInManagerDialog.MESSAGE_COULD_NOT_SAVE") + ex.toString() + "\n" + SwingUITexts.getString("PlugInManagerDialog.MESSAGE_CHECK_PLUG_IN_FILE"), (Throwable)ex);
                }
            } else if (e.getSource() == this.loadButton && (messages = this.manager.loadPlugIns(this.loader, true)).size() > 0) {
                this.platform.getUI().sendMessage(messages, SwingUITexts.getString("PlugInManagerDialog.TITLE_LOADING_PLUG_INS"), (byte)0);
            }
        }
        catch (Throwable ex) {
            this.platform.handleError(ex.toString(), ex);
        }
    }
}

