/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.data;

import java.util.HashMap;
import java.util.Map;
import net.sf.apptools.data.ConvertibleDataDescriptor;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DataHolder;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.StringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataHolderUtils {
    public static Converter getToValueConverter(DataDescriptor dd) {
        ConvertibleDataDescriptor cdd;
        Converter c;
        Class<?> type = dd.getDataType();
        if (dd instanceof ConvertibleDataDescriptor && (c = (cdd = (ConvertibleDataDescriptor)dd).getToValueConverter()) != null) {
            return c;
        }
        return ConvertUtils.lookup(type);
    }

    public static Converter getToStringConverter(DataDescriptor dd) {
        ConvertibleDataDescriptor cdd;
        Converter c;
        if (dd instanceof ConvertibleDataDescriptor && (c = (cdd = (ConvertibleDataDescriptor)dd).getToStringConverter()) != null) {
            return c;
        }
        return new StringConverter();
    }

    public static Object[] getOrderedValues(DataHolder dh) {
        DataDescriptor[] dds = dh.getDataDescriptors();
        Object[] values = new Object[dds.length];
        for (int i = 0; i < dds.length; ++i) {
            values[i] = dh.getData(dds[i].getKey());
        }
        return values;
    }

    public static void putOrderedData(Object[] values, DataHolder dh) {
        DataDescriptor[] dds = dh.getDataDescriptors();
        for (int i = 0; i < dds.length; ++i) {
            Object value = values[i];
            if (value == null) {
                dh.setData(dds[i].getKey(), null);
                continue;
            }
            Class<?> type = dds[i].getDataType();
            if (type.isAssignableFrom(value.getClass())) {
                dh.setData(dds[i].getKey(), value);
                continue;
            }
            Converter toValueConverter = DataHolderUtils.getToValueConverter(dds[i]);
            if (toValueConverter == null) {
                throw new RuntimeException("No Converter found for " + type);
            }
            dh.setData(dds[i].getKey(), toValueConverter.convert(type, value));
        }
    }

    public static Map<String, String> getProperties(DataHolder dh) {
        HashMap<String, String> p = new HashMap<String, String>();
        DataDescriptor[] dds = dh.getDataDescriptors();
        for (int i = 0; i < dds.length; ++i) {
            String key = dds[i].getKey();
            Object value = dh.getData(key);
            String string = (String)DataHolderUtils.getToStringConverter(dds[i]).convert(String.class, value);
            p.put(key, string);
        }
        return p;
    }

    public static DataDescriptor getDescriptorForKey(DataHolder dh, String key) {
        DataDescriptor[] dds = dh.getDataDescriptors();
        for (int i = 0; i < dds.length; ++i) {
            if (!dds[i].getKey().equals(key)) continue;
            return dds[i];
        }
        return null;
    }
}

