/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.apptools.plugin.AbstractPlugInLoader;
import net.sf.apptools.plugin.PlugInLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameFilePlugInLoader
implements PlugInLoader {
    File plugInFile;
    ClassLoader auxLoader;
    protected Log log = LogFactory.getLog(AbstractPlugInLoader.class);

    public NameFilePlugInLoader(File f, ClassLoader auxLoader) {
        this.plugInFile = f;
        this.auxLoader = auxLoader;
    }

    @Override
    public List<String> getAvailablePlugIns(Class<?>[] pluginClasses, Collection<Class<?>>[] classes) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.plugInFile));
            while (reader.ready()) {
                try {
                    String str = reader.readLine();
                    if (str.length() <= 0 || str.startsWith("#")) continue;
                    Class<?> c = Class.forName(str, true, this.auxLoader);
                    this.log.debug((Object)("Checking for plug-in: " + c.getName()));
                    for (int i = 0; i < pluginClasses.length; ++i) {
                        if (pluginClasses[i] == null || !pluginClasses[i].isAssignableFrom(c) && pluginClasses[i] != c) continue;
                        if (c.isInterface() || Modifier.isAbstract(c.getModifiers())) {
                            this.log.debug((Object)"  Interface/Abstract class");
                            continue;
                        }
                        try {
                            c.getConstructor(new Class[0]);
                            classes[i].add(c);
                            continue;
                        }
                        catch (SecurityException e1) {
                            messages.add("Security exception: " + e1.getMessage());
                            continue;
                        }
                        catch (NoSuchMethodException e1) {
                            // empty catch block
                        }
                    }
                }
                catch (ClassNotFoundException cnfx) {
                    messages.add("Class not found:" + cnfx.getMessage());
                }
                catch (Throwable ex) {
                    messages.add("Error:" + ex.toString());
                }
            }
        }
        catch (IOException iox) {
            messages.add(iox.getMessage());
        }
        return messages;
    }
}

