/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;

public class JarClassLoader
extends URLClassLoader {
    static URL getJarFileURL(File jarFile) throws MalformedURLException {
        URL url = new URL("jar:file:" + jarFile.getAbsolutePath() + "!/");
        return url;
    }

    public JarClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public boolean hasJar(File jarFile) {
        try {
            URL url = JarClassLoader.getJarFileURL(jarFile);
            List<URL> urls = Arrays.asList(this.getURLs());
            return urls.contains(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public boolean addJar(File jarFile) {
        if (!this.hasJar(jarFile)) {
            try {
                this.addURL(JarClassLoader.getJarFileURL(jarFile));
                return true;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

