/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.data;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.apptools.data.OptionDescriptor;
import net.sf.apptools.ui.swing.data.DataEditor;

class OptionEditor
implements DataEditor {
    JRadioButton[] buttons;
    String[] options;
    String title;
    String tooltip;

    public OptionEditor(OptionDescriptor od) {
        this.options = od.getOptions();
        this.title = od.getName();
        this.tooltip = od.getDescription();
        this.buttons = new JRadioButton[this.options.length];
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new JRadioButton(this.options[i]);
            bg.add(this.buttons[i]);
        }
    }

    public JComponent getEditorComponent() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        JLabel label = new JLabel(this.title);
        label.setToolTipText(this.tooltip);
        label.setAlignmentX(-1.0f);
        label.setFont(label.getFont().deriveFont(1));
        p.add(label);
        for (int i = 0; i < this.buttons.length; ++i) {
            p.add(this.buttons[i]);
        }
        return p;
    }

    public Object getValue() {
        int index = this.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return new Integer(index);
    }

    public void setValue(Object o) {
        int index = -1;
        if (o instanceof Integer) {
            index = (Integer)o;
        } else if (o instanceof String) {
            index = this.getIndexForOption(o.toString());
        }
        if (index < 0) {
            return;
        }
        this.buttons[index].setSelected(true);
    }

    protected int getSelectedIndex() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    protected int getIndexForOption(String option) {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.options[i].equals(option)) continue;
            return i;
        }
        return -1;
    }
}

