/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.calc;

import org.moltools.design.calc.NNParameters;

public abstract class AbstractNNParameters
implements NNParameters {
    protected float dHInit;
    protected float dHInitAT;
    protected float dHInitGC;
    protected float dSInit;
    protected float dSInitAT;
    protected float dSInitGC;
    protected float[][][][] dH = new float[6][6][6][6];
    protected float[][][][] dS = new float[6][6][6][6];

    public float getH(byte x1, byte x2, byte y1, byte y2) {
        return this.dH[x1][x2][y1][y2];
    }

    public float getH(String str) {
        byte[] code = this.getByteCode(str);
        return this.dH[code[0]][code[1]][code[2]][code[3]];
    }

    public float getS(byte x1, byte x2, byte y1, byte y2) {
        return this.dS[x1][x2][y1][y2];
    }

    public float getS(String str) {
        byte[] code = this.getByteCode(str);
        return this.dS[code[0]][code[1]][code[2]][code[3]];
    }

    byte[] getByteCode(String str) {
        byte[] bytes = new byte[4];
        int i = 0;
        int j = 0;
        while (i <= 4) {
            if (i == 2) {
                ++i;
            }
            switch (str.charAt(i)) {
                case '-': {
                    bytes[j] = 4;
                    break;
                }
                case 'A': {
                    bytes[j] = 0;
                    break;
                }
                case 'C': {
                    bytes[j] = 1;
                    break;
                }
                case 'G': {
                    bytes[j] = 2;
                    break;
                }
                case 'T': {
                    bytes[j] = 3;
                    break;
                }
                case '$': {
                    bytes[j] = 5;
                }
            }
            ++i;
            ++j;
        }
        return bytes;
    }

    public float getInitH() {
        return this.dHInit;
    }

    public float getInitS() {
        return this.dSInit;
    }

    public float getInitHAT() {
        return this.dHInitAT;
    }

    public float getInitSAT() {
        return this.dSInitAT;
    }

    public float getInitHGC() {
        return this.dHInitGC;
    }

    public float getInitSGC() {
        return this.dSInitGC;
    }
}

