/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.calc;

import java.util.HashMap;
import java.util.Map;
import org.moltools.design.calc.MeltingPointCalculator;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.impl.SimpleNucleotideSequence;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;
import org.moltools.lib.struct.DefaultNAHybridStructure;
import org.moltools.lib.struct.NAHybridStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApproximateMeltingPointCalculator
extends AbstractParameterHolder
implements MeltingPointCalculator {
    protected static final float base_dd = 78.9f;
    protected static final float base_rr = 78.9f;
    protected static final float base_dr = 78.9f;
    protected static final float logf = 16.6f;
    protected static final float lenf = 820.0f;
    protected static final int strongf = 4;
    protected static final int weakf = 2;
    protected static final int wobblef = 1;
    protected static final int mismatchf = -2;
    protected static final int gapf = -3;
    protected static final float gcf_dd = 0.41f;
    protected static final float gcf_rr = 0.7f;
    protected static final float gcf_dr = 0.8f;

    @Override
    public Map<String, String> getDefaultParameters() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("SODIUM_CONCENTRATION", "0.05");
        return m;
    }

    public ApproximateMeltingPointCalculator() {
        this.parameters = this.getDefaultParameters();
    }

    protected float getSaltAdjustment() {
        double Naconc = Double.parseDouble((String)this.parameters.get("SODIUM_CONCENTRATION"));
        return (float)((double)16.6f * Math.log(Naconc / 0.05) / Math.log(10.0));
    }

    protected int[] countPairTypes(NucleotideSequence seq1, NucleotideSequence seq2) {
        int gaps = 0;
        int mismatches = 0;
        int wobble = 0;
        int strong = 0;
        int weak = 0;
        int secondpos = 1;
        for (int firstpos = seq1.length(); firstpos > 0; --firstpos) {
            Nucleotide nt1 = null;
            Nucleotide nt2 = null;
            try {
                nt1 = seq1.getNucleotideAt(firstpos);
                nt2 = seq2.getNucleotideAt(secondpos);
                char s1 = nt1.getChar();
                char s2 = nt2.getChar();
                if (s1 == '-' || s2 == '-') {
                    ++gaps;
                } else {
                    Nucleotide comp1 = NucleotideSequenceHandler.getComplementNucleotide((Nucleotide)nt1, (byte)seq2.getType());
                    if (comp1.getChar() == s2) {
                        if (s1 == 'G' || s1 == 'C') {
                            ++strong;
                        } else {
                            ++weak;
                        }
                    } else if (s1 == 'G' && (s2 == 'T' || s2 == 'U')) {
                        ++wobble;
                    } else if (s2 == 'G' && (s1 == 'T' || s1 == 'U')) {
                        ++wobble;
                    } else {
                        ++mismatches;
                    }
                }
                ++secondpos;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new UnsupportedOperationException("A problem occurred while checking for mismatches.\n" + ex.getMessage() + "\nSeq1: " + nt1 + ", Seq2: " + nt2);
            }
        }
        int[] result = new int[]{strong, weak, wobble, mismatches, gaps};
        return result;
    }

    protected float getBaseMP(NucleotideSequence seq1, NucleotideSequence seq2) {
        float base;
        float gcf;
        if (seq1.seqString() == null) {
            throw new UnsupportedOperationException("Cannot calculate Tm for null sequences.");
        }
        if (seq2.seqString() == null) {
            throw new UnsupportedOperationException("Cannot calculate Tm for null sequences.");
        }
        if (seq1.length() != seq2.length()) {
            throw new UnsupportedOperationException("Cannot calculate Tm for sequences of different lengths.");
        }
        if (NucleotideSequenceHandler.countPolys((NucleotideSequence)seq1) > 0) {
            throw new UnsupportedOperationException("Cannot calculate Tm for variable sequences");
        }
        if (NucleotideSequenceHandler.countPolys((NucleotideSequence)seq2) > 0) {
            throw new UnsupportedOperationException("Cannot calculate Tm for variable sequences");
        }
        if (seq1.getType() == 0 && seq2.getType() == 0) {
            gcf = 0.41f;
            base = 78.9f;
        } else if (seq1.getType() == 1 && seq2.getType() == 1) {
            gcf = 0.7f;
            base = 78.9f;
        } else {
            gcf = 0.8f;
            base = 78.9f;
        }
        int[] pairs = this.countPairTypes(seq1, seq2);
        int length = seq1.length();
        float Tm = length > 13 ? this.getLongTm(pairs, length, gcf, base) : this.getShortTm(pairs);
        return Tm;
    }

    float getWallaceLongTm(int[] pairs) {
        return 64.9f + 41.0f * ((float)pairs[0] - 16.4f) / ((float)pairs[0] + (float)pairs[1]);
    }

    float getLongTm(int[] pairs, int length, float gcf, float base) {
        int pairvalue = 4 * pairs[0] + 2 * pairs[1] + 1 * pairs[2] + -2 * pairs[3] + -3 * pairs[4];
        float gc = gcf * ((float)pairvalue / (float)length - 2.0f) * 50.0f;
        float len = 820.0f / (float)length;
        return base + gc - len;
    }

    float getShortTm(int[] pairs) {
        return 4 * pairs[0] + 2 * pairs[1] + 1 * pairs[2] + -2 * pairs[3] + -3 * pairs[4];
    }

    private float getMeltingPoint(String s1, String s2) {
        SimpleNucleotideSequence n1 = new SimpleNucleotideSequence("S1", s1, 0);
        SimpleNucleotideSequence n2 = new SimpleNucleotideSequence("S2", s2, 0);
        return this.getMeltingPoint((NucleotideSequence)n1, (NucleotideSequence)n2, (NAHybridStructure)new DefaultNAHybridStructure((Sequence)n1, 1, n1.length(), (Sequence)n2, 1, n2.length()));
    }

    @Override
    public float getMeltingPoint(NucleotideSequence seq1, NucleotideSequence seq2, NAHybridStructure str) {
        float base = this.getBaseMP((NucleotideSequence)new SimpleNucleotideSequence("S1", str.getFirstString(), seq1.getType()), (NucleotideSequence)new SimpleNucleotideSequence("S2", str.getSecondString(), seq2.getType()));
        float salt = this.getSaltAdjustment();
        return base + salt;
    }

    @Override
    public float getMeltingPoint(NucleotideSequence seq) {
        return this.getMeltingPoint(seq.seqString(), NucleotideSequenceHandler.getRevComp((NucleotideSequence)seq));
    }
}

