/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.calc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.moltools.design.calc.AbstractNNParameters;

public abstract class StandardNNParameters
extends AbstractNNParameters {
    protected abstract String getDefaultParameterFileName();

    public StandardNNParameters(Reader in) throws IOException {
        this.dH = new float[6][6][6][6];
        this.dS = new float[6][6][6][6];
        this.initParameters(in);
    }

    public StandardNNParameters() throws IOException {
        this.dH = new float[6][6][6][6];
        this.dS = new float[6][6][6][6];
        String resourcePath = "params/" + this.getDefaultParameterFileName();
        this.initParameters(new InputStreamReader(this.getClass().getResourceAsStream(resourcePath)));
    }

    void initParameters(Reader in) throws IOException {
        if (in == null) {
            throw new UnsupportedOperationException("Cannot load paramaters from null stream");
        }
        for (int x1 = 0; x1 <= 5; ++x1) {
            for (int x2 = 0; x2 <= 5; ++x2) {
                for (int y1 = 0; y1 <= 5; ++y1) {
                    for (int y2 = 0; y2 <= 5; ++y2) {
                        this.dH[x1][x2][y1][y2] = Float.MAX_VALUE;
                        this.dS[x1][x2][y1][y2] = Float.MAX_VALUE;
                    }
                }
            }
        }
        float dHin = Float.MAX_VALUE;
        float dSin = Float.MAX_VALUE;
        byte[] doubletCode = new byte[4];
        String line = "";
        BufferedReader r = new BufferedReader(in);
        while ((line = r.readLine()) != null) {
            String[] substrings = line.split("\t");
            if (line.startsWith("initH")) {
                if (line.startsWith("initH AT")) {
                    this.dHInitAT = Float.parseFloat(substrings[1]);
                    continue;
                }
                if (line.startsWith("initH GC")) {
                    this.dHInitGC = Float.parseFloat(substrings[1]);
                    continue;
                }
                this.dHInit = Float.parseFloat(substrings[1]);
                continue;
            }
            if (line.startsWith("initS")) {
                if (line.startsWith("initS AT")) {
                    this.dSInitAT = Float.parseFloat(substrings[1]);
                    continue;
                }
                if (line.startsWith("initS GC")) {
                    this.dSInitGC = Float.parseFloat(substrings[1]);
                    continue;
                }
                this.dSInit = Float.parseFloat(substrings[1]);
                continue;
            }
            if (line.startsWith("#") || substrings.length <= 0) continue;
            String doubletText = substrings[0];
            if (substrings.length > 1) {
                dHin = Float.parseFloat(substrings[1]);
                dSin = Float.parseFloat(substrings[2]);
            }
            doubletCode = this.getByteCode(doubletText);
            this.dH[doubletCode[0]][doubletCode[1]][doubletCode[2]][doubletCode[3]] = dHin;
            this.dS[doubletCode[0]][doubletCode[1]][doubletCode[2]][doubletCode[3]] = dSin;
        }
        r.close();
        for (int x = 0; x <= 3; ++x) {
            int y;
            if (x == 0 || x == 3) {
                y = 3 - x;
                this.dH[x][5][y][5] = 2200.0f;
                this.dS[x][5][y][5] = 6.9f;
                this.dH[5][x][5][y] = 2200.0f;
                this.dS[5][x][5][y] = 6.9f;
                continue;
            }
            y = 3 - x;
            this.dH[x][5][y][5] = 0.0f;
            this.dS[x][5][y][5] = 0.0f;
            this.dH[5][x][5][y] = 0.0f;
            this.dS[5][x][5][y] = 0.0f;
        }
    }
}

