/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.data.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.moltools.design.data.impl.SimpleProperty;
import org.moltools.design.properties.MutablePropertySet;
import org.moltools.design.properties.Property;
import org.moltools.design.properties.PropertySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertySet
implements MutablePropertySet {
    protected Map<String, List<?>> propMap = new HashMap();

    @Override
    public void addProperty(Property p) {
        boolean exists;
        boolean allowsMulti = p.allowsMultipleValues();
        List<?> l = this.propMap.get(p.getKey());
        boolean bl = exists = l != null;
        if (exists && !allowsMulti) {
            throw new UnsupportedOperationException("Multiple properties with key " + p.getKey() + " not allowed");
        }
        if (l == null) {
            l = new ArrayList();
        }
        l.add(p.getValue());
        this.propMap.put(p.getKey(), l);
    }

    @Override
    public void setProperty(Property p) {
        this.propMap.put(p.getKey(), Collections.singletonList(p.getValue()));
    }

    @Override
    public List<?> getMultiPropertyValues(String key) {
        return this.propMap.get(key);
    }

    @Override
    public Object getSinglePropertyValue(String key) {
        List<?> l = this.propMap.get(key);
        if (l == null) {
            return null;
        }
        if (l.isEmpty()) {
            return null;
        }
        if (l.size() > 1) {
            throw new UnsupportedOperationException("There are multiple property values for " + key);
        }
        return l.get(0);
    }

    @Override
    public void removeAllProperties() {
        this.propMap.clear();
    }

    @Override
    public void removeProperties(String key) {
        this.propMap.remove(key);
    }

    @Override
    public void removeProperty(Property p) {
        this.removeProperty((KeyValue)new DefaultKeyValue((Object)p.getKey(), p.getValue()));
    }

    public void removeProperty(KeyValue kv) {
        List<?> l = this.propMap.get(kv.getKey());
        Iterator<?> i = l.iterator();
        while (i.hasNext()) {
            if (!kv.getValue().equals(i.next())) continue;
            i.remove();
        }
    }

    @Override
    public Iterator<KeyValue> getKeyValueIterator() {
        HashSet<DefaultKeyValue> s = new HashSet<DefaultKeyValue>();
        for (String key : this.propMap.keySet()) {
            Iterator<?> i2 = this.propMap.get(key).iterator();
            while (i2.hasNext()) {
                s.add(new DefaultKeyValue((Object)key, i2.next()));
            }
        }
        return s.iterator();
    }

    @Override
    public void addAllProperties(PropertySet ps) {
        Iterator<KeyValue> i = ps.getKeyValueIterator();
        while (i.hasNext()) {
            KeyValue kv = i.next();
            String key = (String)kv.getKey();
            Object value = kv.getValue();
            this.addProperty(new SimpleProperty(key, value, true));
        }
    }
}

