/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.data.impl;

import org.moltools.design.data.TargettedSequence;
import org.moltools.design.data.TargettedSubSequence;
import org.moltools.design.data.impl.SimpleSubSequenceTemplate;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.seq.SubSequenceDescriptor;

public class TemplateHandler {
    public static final byte NONE = 0;
    public static final byte FIVEPRIME = 1;
    public static final byte THREEPRIME = 2;
    public static final byte BOTH = 3;

    public static TargettedSequence subTemplate(TargettedSubSequence temp, int length, byte fixedEnd) {
        int begin = temp.getStart();
        int end = temp.getEnd();
        switch (fixedEnd) {
            case 1: {
                if (length == 0) {
                    return new SimpleSubSequenceTemplate(temp.getID(), "", temp.getType(), end, end, DesignUtils.getTargetID(temp));
                }
                int startIndex = Math.max(temp.length() + 1 - length, 1);
                int newBegin = startIndex - 1 + begin;
                return new SimpleSubSequenceTemplate(temp.getID(), temp.subsequence(startIndex, temp.length()), temp.getType(), newBegin, end, DesignUtils.getTargetID(temp));
            }
            case 2: {
                if (length == 0) {
                    return new SimpleSubSequenceTemplate(temp.getID(), "", temp.getType(), begin, begin, DesignUtils.getTargetID(temp));
                }
                int stopIndex = Math.min(temp.length(), length);
                int newEnd = stopIndex - 1 + begin;
                return new SimpleSubSequenceTemplate(temp.getID(), temp.subsequence(1, stopIndex), temp.getType(), begin, newEnd, DesignUtils.getTargetID(temp));
            }
            case 3: {
                throw new UnsupportedOperationException("Cannot return subTemplate if both ends are fixed");
            }
        }
        throw new UnsupportedOperationException("Incorrect end mode");
    }

    public static int[] subTemplatePositions(SubSequenceDescriptor temp, int length, byte fixedEnd) {
        int begin = temp.getStart();
        int end = temp.getEnd();
        switch (fixedEnd) {
            case 1: {
                int startIndex = Math.max(temp.length() + 1 - length, 1);
                int newBegin = startIndex - 1 + begin;
                return new int[]{newBegin, end};
            }
            case 2: {
                int stopIndex = Math.min(temp.length(), length);
                int newEnd = stopIndex - 1 + begin;
                return new int[]{begin, newEnd};
            }
            case 3: {
                if (length != temp.length()) {
                    throw new UnsupportedOperationException("Cannot return subTemplate of different length");
                }
                return new int[]{begin, end};
            }
        }
        throw new UnsupportedOperationException("Incorrect end mode");
    }
}

