/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.apptools.graph.DirectedEdge;
import net.sf.apptools.graph.Graph;
import net.sf.apptools.graph.GraphEdge;
import net.sf.apptools.graph.GraphVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphUtils {
    static final Byte WHITE = new Byte(0);
    static final Byte GREY = new Byte(1);
    static final Byte BLACK = new Byte(2);
    static int time;

    public static Collection<GraphVertex> getSuccessorVertices(GraphVertex v) {
        HashSet<GraphVertex> successors = new HashSet<GraphVertex>();
        for (GraphEdge e : v.getEdges()) {
            DirectedEdge de;
            if (!(e instanceof DirectedEdge) || !(de = (DirectedEdge)e).getFromVertex().equals(v)) continue;
            successors.add(de.getToVertex());
        }
        return successors;
    }

    public static List<?> getSortedContents(Map<Integer, GraphVertex> contentMap, String key) {
        ArrayList<Object> l = new ArrayList<Object>();
        for (GraphVertex v : contentMap.values()) {
            l.add(v.getData(key));
        }
        return l;
    }

    public static synchronized Map<Integer, GraphVertex> DFSTopoSort(Graph dg) {
        HashMap<GraphVertex, Byte> colors = new HashMap<GraphVertex, Byte>();
        HashMap<GraphVertex, GraphVertex> parents = new HashMap<GraphVertex, GraphVertex>();
        TreeMap<Integer, GraphVertex> topoSort = new TreeMap<Integer, GraphVertex>();
        time = 0;
        for (GraphVertex v : dg.getVertices()) {
            colors.put(v, WHITE);
            parents.put(v, null);
        }
        for (GraphVertex v : dg.getVertices()) {
            if (colors.get(v) != WHITE || !GraphUtils.DFSVisit(v, colors, parents, topoSort)) continue;
            return null;
        }
        return topoSort;
    }

    public static boolean DFSVisit(GraphVertex v, Map<GraphVertex, Byte> colors, Map<GraphVertex, GraphVertex> parents, Map<Integer, GraphVertex> topoSort) {
        colors.put(v, GREY);
        Collection<GraphVertex> adj = GraphUtils.getSuccessorVertices(v);
        for (GraphVertex u : adj) {
            Byte color = colors.get(u);
            if (color == WHITE) {
                parents.put(u, v);
                GraphUtils.DFSVisit(u, colors, parents, topoSort);
                continue;
            }
            if (color != GREY) continue;
            return true;
        }
        colors.put(v, BLACK);
        topoSort.put(new Integer(++time), v);
        return false;
    }
}

