/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.utils;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import net.sf.apptools.utils.HTMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLLogWriter {
    private HTMLWriter writer;

    public HTMLLogWriter(PrintWriter p) {
        this.writer = p == null ? null : new HTMLWriter(p);
    }

    public void begin(String taskDescriptor, String title, Date start) {
        if (this.writer == null) {
            return;
        }
        this.writer.printTag(HTMLWriter.HTML);
        this.writer.printAttributeTag(HTMLWriter.HEAD, new String[]{"TITLE"}, new String[]{title});
        this.writer.printEndTag(HTMLWriter.HEAD);
        this.writer.printTag(HTMLWriter.BODY);
        this.writer.printEnclosed(taskDescriptor, HTMLWriter.H3);
        this.writer.printText("Started: " + DateFormat.getDateInstance(3).format(start) + " " + DateFormat.getTimeInstance(3).format(start));
    }

    public void printParameters(Properties params) {
        if (this.writer == null) {
            return;
        }
        Enumeration<?> e = params.propertyNames();
        while (e.hasMoreElements()) {
            String propname = (String)e.nextElement();
            this.printLine(propname + ": " + params.getProperty(propname));
        }
    }

    public void printHeader(String text) {
        if (this.writer == null) {
            return;
        }
        this.writer.printEnclosed(text, HTMLWriter.H4);
    }

    public void printLineAndHeader(String text) {
        if (this.writer == null) {
            return;
        }
        this.writer.printTag(HTMLWriter.HR);
        this.writer.printEnclosed(text, HTMLWriter.H4);
    }

    public void printList(Collection<?> list) {
        if (this.writer == null) {
            return;
        }
        this.writer.printTag(HTMLWriter.UL);
        Iterator<?> i = list.iterator();
        while (i.hasNext()) {
            this.writer.printEnclosed(i.next().toString(), HTMLWriter.LI);
        }
        this.writer.printEndTag(HTMLWriter.UL);
    }

    public void printParagraph(String text) {
        if (this.writer == null) {
            return;
        }
        this.writer.printEnclosed(text, HTMLWriter.P);
    }

    public void printLine(String text) {
        if (this.writer == null) {
            return;
        }
        this.writer.println(text);
    }

    public void printError(String text) {
        if (this.writer == null) {
            return;
        }
        this.writer.printEnclosed(text, HTMLWriter.B);
        this.writer.printTag(HTMLWriter.BR);
    }

    public void end() {
        if (this.writer == null) {
            return;
        }
        this.writer.printTag(HTMLWriter.HR);
        this.writer.printText("Finished: " + DateFormat.getDateInstance(3).format(new Date()) + " " + DateFormat.getTimeInstance(3).format(new Date()));
        this.writer.printEndTag(HTMLWriter.BODY);
        this.writer.printEndTag(HTMLWriter.HTML);
        this.writer.close();
    }
}

