/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.ext;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import net.sf.apptools.Platform;
import net.sf.apptools.actions.AbstractUserAction;
import net.sf.apptools.actions.ActionSet;
import net.sf.apptools.actions.UserAction;
import net.sf.apptools.plugin.ActivePlugIn;
import org.moltools.lib.seq.alphabet.DegenerateNAAlphabet;
import org.moltools.lib.seq.alphabet.DegenerateNucleotide;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.workbench.ext.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DegeneracyCodePlugIn
implements ActivePlugIn {
    Platform platform;

    public static String getBriefDescription() {
        return Messages.getString("DegeneracyCodePlugIn.BRIEF_DESCRIPTION");
    }

    public static String getLongDescription() {
        return Messages.getString("DegeneracyCodePlugIn.LONG_DESCRIPTION");
    }

    public Map<String, String> getPlugInRequirements() {
        return null;
    }

    public void setup(final Platform platform) {
        this.platform = platform;
        String name = Messages.getString("DegeneracyCodePlugIn.NAME_SHOW_NUCLEOTIDE_SYMBOLS");
        AbstractUserAction a = new AbstractUserAction(name, name){

            public void execute() {
                TreeSet<String> strings = new TreeSet<String>();
                DegenerateNAAlphabet set = DegenerateNAAlphabet.degenerateAlphabet;
                for (Nucleotide n : set) {
                    if (!(n instanceof DegenerateNucleotide) || n.getType() != 0) continue;
                    StringBuffer text = new StringBuffer();
                    DegenerateNucleotide dn = (DegenerateNucleotide)n;
                    text.append(dn.getChar());
                    text.append(" = ");
                    Nucleotide[] poss = dn.getPossible();
                    for (int j = 0; j < poss.length; ++j) {
                        text.append((j > 0 ? "/" : "") + poss[j].getChar());
                    }
                    strings.add(text.toString());
                }
                platform.getUI().sendMessage(new ArrayList(strings), Messages.getString("DegeneracyCodePlugIn.TITLE_NUCLEOTIDE_SYMBOLS"), (byte)0);
            }
        };
        platform.addActionSet(new ActionSet(new UserAction[]{a}, Messages.getString("DegeneracyCodePlugIn.MENU_NAME_HELP"), (ActivePlugIn)this));
    }

    public boolean teardown() {
        this.platform.removeActionSets((ActivePlugIn)this);
        return true;
    }

    public String getVersion() {
        return "1.0.0";
    }
}

