/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.ext.ops;

import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.IntegerDescriptor;
import net.sf.apptools.plugin.AbstractParameterPlugIn;
import org.moltools.lib.Renameable;
import org.moltools.lib.seq.ChangeableSequence;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.workbench.ext.SequenceOperation;

public class CircularlyPermute
extends AbstractParameterPlugIn
implements SequenceOperation {
    public static final String KEY_START = "START";
    static DataDescriptor[] descriptors = new DataDescriptor[]{new IntegerDescriptor("Start position", "The new starting position (0 not allowed)", "START", -2147483647, Integer.MAX_VALUE)};
    private boolean changename = true;

    public CircularlyPermute() {
        super(descriptors);
    }

    public static String getBriefDescription() {
        return "Circularly permute";
    }

    public static String getLongDescription() {
        return "Circularly permute the sequence around a specified position";
    }

    public void operate(ChangeableSequence s) {
        int length;
        int startPos = (Integer)this.getData(KEY_START);
        int start = startPos % (length = s.length());
        if (start < 0) {
            start = length + start + 1;
        }
        if (start > 1) {
            try {
                s.setSequence(s.subsequence(start, length) + s.subsequence(1, start - 1));
            }
            catch (SequenceFormatException ex) {
                throw new UnsupportedOperationException(ex.getMessage());
            }
            String add = "|CircPerm" + startPos;
            if (this.changename) {
                s.setID(s.getID() + add);
                if (s instanceof Renameable) {
                    Renameable n = (Renameable)s;
                    n.setName(n.getName() + add);
                }
            }
        }
    }
}

