/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.gui;

import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.moltools.lib.Renameable;
import org.moltools.lib.seq.ChangeableSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.SequenceView;
import org.moltools.lib.seq.db.ChangeableSequenceDB;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.IndexedSequenceDB;
import org.moltools.lib.seq.db.SequenceDBChangeListener;
import org.moltools.lib.seq.db.impl.ListSequenceDB;
import org.moltools.workbench.gui.DefaultSequenceView;
import org.moltools.workbench.gui.Messages;
import org.moltools.workbench.gui.SequenceTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSequenceTableModel
extends AbstractTableModel
implements SequenceTableModel,
SequenceDBChangeListener {
    private static final long serialVersionUID = 1L;
    protected DefiniteSequenceDB<? extends Sequence> db;
    protected IndexedSequenceDB<Sequence> modeldb;
    protected int rowCount;
    protected int colCount;
    protected String[] colNames;
    protected boolean editable;
    protected static final int defaultRowCount = 10;
    protected static final String[] defaultColNames = new String[]{Messages.getString("DefaultSequenceTableModel.HEADER_DESCRIPTION"), Messages.getString("DefaultSequenceTableModel.HEADER_SEQUENCE")};

    public DefaultSequenceTableModel() {
        this(null, defaultColNames);
    }

    public DefaultSequenceTableModel(DefiniteSequenceDB<?> _library) {
        this(_library, defaultColNames);
    }

    public DefaultSequenceTableModel(DefiniteSequenceDB<?> db, Object[] _colNames) {
        this.setLibrary(db);
        this.colNames = (String[])_colNames;
        this.colCount = this.colNames.length;
        this.editable = false;
    }

    public void setLibrary(DefiniteSequenceDB<? extends Sequence> newDB) {
        if (this.db instanceof ChangeableSequenceDB) {
            ((ChangeableSequenceDB)this.db).removeChangeListener((SequenceDBChangeListener)this);
        }
        if (newDB instanceof ChangeableSequenceDB) {
            ((ChangeableSequenceDB)newDB).addChangeListener((SequenceDBChangeListener)this);
        }
        this.db = newDB;
        if (newDB instanceof IndexedSequenceDB) {
            this.modeldb = (IndexedSequenceDB)this.db;
        } else {
            this.modeldb = new ListSequenceDB();
            if (this.db != null) {
                ((ListSequenceDB)this.modeldb).addSequences(this.db);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.colCount;
    }

    @Override
    public int getRowCount() {
        if (this.modeldb == null) {
            return 10;
        }
        return this.modeldb.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.colNames[col];
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        try {
            Sequence s = this.getSequenceAt(parm1);
            Object view = s instanceof SequenceView ? (SequenceView)s : new DefaultSequenceView(s);
            switch (parm2) {
                case 0: {
                    return view.getViewName();
                }
                case 1: {
                    return view.getViewSequence();
                }
            }
            throw new UnsupportedOperationException("Column index out of bounds " + parm2);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UnsupportedOperationException("Library: " + this.modeldb + "Row index out of bounds " + parm1);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        Sequence s = this.getSequenceAt(row);
        switch (col) {
            case 0: {
                return s instanceof Renameable;
            }
            case 1: {
                return s instanceof ChangeableSequence;
            }
        }
        throw new IllegalArgumentException("Column does not exist");
    }

    @Override
    public Sequence getSequenceAt(int row) {
        return this.modeldb.getSequenceAt(row);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        try {
            Sequence s = this.getSequenceAt(row);
            switch (col) {
                case 0: {
                    ((Renameable)s).setName((String)value);
                    break;
                }
                case 1: {
                    try {
                        ((ChangeableSequence)s).setSequence((String)value);
                    }
                    catch (SequenceFormatException sfx) {
                        JOptionPane.showMessageDialog(null, sfx.getMessage());
                    }
                    catch (ClassCastException ccx) {
                        JOptionPane.showMessageDialog(null, "This sequence is not editable");
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Column index out of bounds: " + col);
                }
            }
            this.fireTableCellUpdated(row, col);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UnsupportedOperationException("Row index out of bounds.");
        }
        catch (ClassCastException ccx) {
            throw new UnsupportedOperationException("Not editable");
        }
    }

    @Override
    public Class<?> getColumnClass(int col) {
        Class colClass = Object.class;
        colClass = col == 1 ? Sequence.class : super.getColumnClass(col);
        return colClass;
    }

    public void contentsChanged(ChangeableSequenceDB<?> source) {
        this.fireTableDataChanged();
    }
}

