/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import net.sf.apptools.ui.swing.utils.GUIUtils;
import net.sf.apptools.ui.swing.utils.HTMLViewPanel;
import net.sf.apptools.utils.HTMLRenderer;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.utils.SequenceHandler;
import org.moltools.workbench.SequenceHTMLRenderer;
import org.moltools.workbench.gui.Messages;
import org.moltools.workbench.gui.SequenceTableModel;

public class SequenceTableListener
implements ActionListener,
MouseListener {
    protected JPopupMenu popupMenu;
    protected JMenuItem viewSequence;
    protected JMenuItem getRev;
    protected SequenceTableModel dataModel;
    protected JTable table;
    protected HTMLRenderer renderer;

    public SequenceTableListener(JTable table, SequenceTableModel tableModel) {
        this(table, tableModel, (HTMLRenderer)new SequenceHTMLRenderer(null));
    }

    public SequenceTableListener(JTable table, SequenceTableModel tableModel, HTMLRenderer seqHTMLRenderer) {
        this.dataModel = tableModel;
        this.table = table;
        this.renderer = seqHTMLRenderer;
        this.viewSequence = new JMenuItem(Messages.getString("SequenceTableListener.CAPTION_VIEW_SEQUENCE"));
        this.viewSequence.addActionListener(this);
        this.getRev = new JMenuItem(Messages.getString("SequenceTableListener.CAPTION_GET_REVERSE"));
        this.getRev.addActionListener(this);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.viewSequence);
        this.popupMenu.add(this.getRev);
        table.addMouseListener(this);
    }

    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseEntered(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseExited(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseClicked(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    protected void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger() && this.popupMenu != null) {
            int row = this.table.rowAtPoint(e.getPoint());
            this.table.setRowSelectionInterval(row, row);
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected void viewSequence(Sequence s) {
        if (this.renderer.canRenderHTML((Object)s)) {
            HTMLViewPanel vp = new HTMLViewPanel((Object)s, this.renderer);
            JFrame frame = new JFrame(vp.getTitle());
            frame.setContentPane((Container)vp);
            frame.pack();
            if (frame.getPreferredSize().width > 200 && frame.getPreferredSize().height > 200) {
                frame.setSize(frame.getPreferredSize());
            } else {
                frame.setSize(400, 400);
            }
            frame.setLocation(GUIUtils.suggestLocation((Window)frame, (Frame)GUIUtils.getParentFrame((Component)this.table)));
            frame.setVisible(true);
        } else {
            JTextArea sf = new JTextArea();
            sf.setFont(new Font("monospaced", 0, 12));
            sf.setText(s.seqString());
            sf.setEditable(false);
            JOptionPane.showMessageDialog(GUIUtils.getParentFrame((Component)this.table), sf, s.getID(), -1);
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Component src = (Component)e.getSource();
            int row = this.table.getSelectedRow();
            if (src == this.viewSequence) {
                if (row > -1) {
                    this.viewSequence(this.dataModel.getSequenceAt(row));
                }
            } else if (src == this.getRev && row > -1) {
                Sequence s = this.dataModel.getSequenceAt(row);
                JTextArea sf = new JTextArea();
                sf.setFont(new Font("monospaced", 0, 12));
                sf.setText(SequenceHandler.getRev((String)s.seqString()));
                sf.setEditable(false);
                JOptionPane.showMessageDialog(GUIUtils.getParentFrame((Component)this.table), sf, Messages.getString("SequenceTableListener.TITLE_REVERSE") + s.getID(), -1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(GUIUtils.getParentFrame((Component)this.table), ex.getMessage(), Messages.getString("SequenceTableListener.TITLE_EXCEPTION"), 0);
        }
    }

    public HTMLRenderer getRenderer() {
        return this.renderer;
    }

    public JTable getTable() {
        return this.table;
    }

    public SequenceTableModel getTableModel() {
        return this.dataModel;
    }
}

