/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.transformers;

import org.apache.commons.collections.Transformer;
import org.moltools.design.transformers.SequenceTransformer;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.PolarSubSequenceDescriptor;
import org.moltools.lib.seq.impl.SimpleNucleotideSubSequence;
import org.moltools.lib.seq.impl.SimpleNucleotideSubSequenceDescriptor;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

public class RangeSubSequenceTransformer
implements Transformer,
SequenceTransformer {
    protected byte polarity;
    protected int from;
    protected int to;

    public RangeSubSequenceTransformer(int from, int to, byte polarity) {
        this.from = from;
        this.to = to;
        this.polarity = polarity;
    }

    public RangeSubSequenceTransformer() {
    }

    public Object transform(Object input) {
        NucleotideSequence parent = (NucleotideSequence)input;
        SimpleNucleotideSubSequenceDescriptor pssd = new SimpleNucleotideSubSequenceDescriptor(parent.getID(), this.from, this.to, this.polarity);
        String id = NucleotideSequenceHandler.makeSubSequenceID((PolarSubSequenceDescriptor)pssd);
        String seqString = NucleotideSequenceHandler.getNucleotideSubSequenceString((NucleotideSequence)parent, (PolarSubSequenceDescriptor)pssd);
        SimpleNucleotideSubSequence subseq = new SimpleNucleotideSubSequence(id, seqString, parent.getType(), (PolarSubSequenceDescriptor)pssd);
        return subseq;
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public byte getPolarity() {
        return this.polarity;
    }

    public void setPolarity(byte polarity) {
        this.polarity = polarity;
    }

    public int getTo() {
        return this.to;
    }

    public void setTo(int to) {
        this.to = to;
    }
}

