# $Id: Canvas.pm,v 1.1 2003/04/29 18:16:54 malay Exp $
# Perl module for BioSVG::Canvas
# Author: Malay < curiouser@ccmb.res.in >
# Copyright (c) 2003 by Malay. All rights reserved.
# You may distribute this module under the same terms as perl itself

=head1 NAME

BioSVG::Canvas - The Canvas on which BioSVG objects are drawn.

=head1 SYNOPSIS

  use BioSVG;
  my $canvas = BioSVG::Canvas->new();
  my $plasmid = BioSVG::PlasmidFactory->get_circular_plasmid(-name=>"someplasmid",
                                                             -size=> 8000);
  my $canvas->add($plasmid);
  my $canvas->show();


=head1 DESCRIPTION

BioSVG canvas in the new addition to BioSVG framework. Earlier each
BioSVG objects were used directly as a subclass of C<Pastel::Graphics>
class which were creating problems in storing the graphics
context. That was also preventing drawing several different types of
BioSVG classes to draw in the same SVG document. Now this restriction
has been removed. Now C<BioSVG> canvas is the only class that is subclass of C<Pastel::Graphics>.

=cut


package BioSVG::Canvas;
@ISA = qw(Pastel::Graphics);


use Pastel;
use strict;


=head1 CONSTRUCTOR

=cut

sub new {
  my ($class, @args) = @_;
  $class = ref($class)||$class;
  my $self = $class->SUPER::new(@args);
  bless $self, $class;
  #$self->_init(@args);
 
    #print "****", $self->{_mac_header}, "\n";
    return $self;
}

sub _init {
# print STDERR "***init in Canvas\n";
  my ($self, @args) = @_;
  $self->SUPER::_init(@args);

  #set default stroke
 # $self->set_stroke(Pastel::BasicStroke->new());
}


=head1 METHODS

=head2 add()

Describe your function here

 Usage   : 
 Args    : 
 Returns : 

=cut

sub add {
  my $self = shift;
  my $object = shift;
  #print STDERR "add called \n";
  $object->paint($self);

}

=head2 get_graphics()

Describe your function here

 Usage   : 
 Args    : 
 Returns : 

=cut

sub get_graphics {
  my $self = shift;
  return $self;

}


=head1 SEE ALSO


=head1 COPYRIGHTS

Copyright (c) 2003 by Malay <curiouser@ccmb.res.in>. All rights reserved.

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=cut

1;
