# $Id: CircularPlasmid.pm,v 1.1 2003/07/12 12:09:44 malay Exp $
# Perl module for BioSVG::CircularPlasmid
# Author: Malay < curiouser@ccmb.res.in >
# Copyright (c) 2003 by Malay. All rights reserved.
# You may distribute this module under the same terms as perl itself

=head1 NAME

BioSVG::CircularPlasmid - DESCRIPTION of Object

=head1 SYNOPSIS

Give standard usage here

=head1 DESCRIPTION

Describe the object here

=cut

package BioSVG::CircularPlasmid;
@ISA = qw(BioSVG::Plasmid);

#@EXPORT_OK = qw();

use strict;

=head1 CONSTRUCTOR

=cut

sub new {
    my $class = shift;

    my $self = {};
    bless $self, ref($class) || $class;
    $self->_init(@_);
    return $self;
}

sub _init {
    my ( $self, @args ) = @_;
    my ( $name, $size, $radius ) =
      $self->_rearrange( [ "NAME", "SIZE", "RADIUS" ], @args );

    $self->{name} = $name;
    $self->{size} = $size;

    #  $self->{radius} = $radius ? $radius : 150;
    $self->{markers}  = [];
    $self->{enzymes}  = [];
    $self->{backbone} = undef;
    $self->{mcs}      = undef;

    # $self->set_backbone_font(
    #        Pastel::Font->new( "Myriad,Helvetica,Arial", "Bold", 12 ) );

    # my $make = $self->SUPER::_init;
    #return $make; # success - we hope!
}

=head1 METHODS


=head2 get_size()

Describe your function here

 Usage   : 
 Args    : 
 Returns : 

=cut

sub get_size {
    return $_[0]->{size};

}

=head2 get_radius()

Describe your function here

 Usage   : 
 Args    : 
 Returns : 

=cut

sub get_radius {
    return $_[0]->{radius};

}

=head2 set_radius()

Describe your function here

 Usage   : 
 Args    : 
 Returns : 

=cut

sub set_radius {
    my ( $self, $radius ) = @_;
    $self->{radius} = $radius;

}

=head2 get_graphics()

Describe your function here

 Usage   : 
 Args    : 
 Returns : 

=cut

sub get_graphics {
    return $_[0]->{graphics} || undef;

}

sub paint {

    #print STDERR "Inside paint\n";
    my ( $self, $args ) = @_;
    $self->{graphics} = $args;
    $self->{cx}       = $self->get_graphics()->get_width() / 2;
    $self->{cy}       = $self->get_graphics()->get_height() / 2;
    $self->paint_backbone();

    # print STDERR "***", $self->{radius},"\n";

}

=head2 draw_backbone()

Describe your function here

 Usage   : 
 Args    : 
 Returns : 

=cut

sub draw_backbone {
    my ( $self, @args ) = @_;
    my ( $width, $stroke_color, $font, $text_color, $scale ) =
      Pastel::Mixin::Mixin->_rearrange(
        [ "WIDTH", "STROKE_COLOR", "FONT", "TEXT_COLOR", "SCALE" ], @args );
    my @arguments;

    if ( !$width ) {
        $width = 2;
    }

    push ( @arguments, "width", $width );
    if ($stroke_color) {
        unless ( $stroke_color->isa("Pastel::Color")
            || $stroke_color->isa("Pastel::GradientI") )
        {
            $self->throw(
"Stroke color should be a Pastel::GradientI or Pastel::Color object"
            );
        }
    }
    else {
        $stroke_color = Pastel::Color->black();
    }
    push ( @arguments, "stroke_color", $stroke_color );

    if ($font) {
        if ( !$font->isa("Pastel::Font") ) {
            $self->throw("Font has to be Pastel::Font object");
        }
    }
    else {
        $font = $self->get_backbone_font();
    }
    push ( @arguments, "font", $font );

    if ($text_color) {
        unless ( $text_color->isa("Pastel::Color")
            || $text_color->isa("Pastel::GradientI") )
        {
            $self->throw(
"Text color should be a Pastel::GradientI or Pastel::Color object"
            );
        }
    }
    else {
        $text_color = $self->get_basic_color();

    }
    push ( @arguments, "text_color", $text_color );

    if ( $scale && ( $scale =~ /on/i ) ) {
        push ( @arguments, "scale", 1 );
    }

    $self->{backbone} = BioSVG::Plasmid::Backbone->new(@arguments);
}

sub paint_backbone {
    my $self     = shift;
    my $g        = $self->get_graphics();
    my $backbone = $self->get_backbone();

    # print STDERR "***",$backbone->get_width(),"\n";
    $g->set_stroke(
        Pastel::BasicStroke->new( -width => $backbone->get_width() ) );
    if ( my $sc = $backbone->get_stroke_color() ) {
        $g->set_paint($sc);
    }
    my $circle = Pastel::Geometry::Circle->new(
        $self->{cx} - $self->{radius},
        $self->{cy} - $self->{radius},
        $self->{radius} * 2
    );

    #my $rect = Pastel::Geometry::Rectangle->new(20,30, 50,100);
    #$g->draw_string("Hello", 20, 30);
    $g->draw($circle);

    $self->_paint_name($g);
    if ( $backbone->scale_on() ) {
        $self->_paint_scale($g);
    }
}

sub _paint_name {
    my ( $self, $g ) = @_;
    my $name     = $self->get_name();
    my $backbone = $self->get_backbone();
    if ( $name && ref($name) ) {
        $self->throw("Illegal parameter")
          unless $name->isa("Pastel::AttributedString");
        if ( $name->isa("Pastel::AttributedString") ) {
            $name->add_attribute( "ANCHOR", "MIDDLE" );
            $g->draw_string( $name, $self->{cx}, $self->{cy} );
        }
    }
    else {
        my $string = Pastel::Text::AttributedString->new($name);
        my $font;
        if ( my $f = $backbone->get_font() ) {
            $font = $f;
        }
        else {
            $font = $self->get_backbone_font();
        }
        $string->add_attribute( "FONT",   $font );
        $string->add_attribute( "ANCHOR", "MIDDLE" );
        $string->add_attribute( "COLOR",  $backbone->get_text_color() );
        $g->draw_string( $string, $self->{cx}, $self->{cy} );

    }
}

#sub _paint_scale {
#    my ( $self, $g ) = @_;
#    my $tick_height = 5;
#    my $backbone    = $self->get_backbone();

#    $g->set_stroke( $self->get_basic_stroke() );
#    if ( my $sc = $backbone->get_stroke_color() ) {
#        $g->set_paint($sc);
#    }

#    my $radian = $self->_get_radian( $self->get_size(), 0 );
#    my ( $x, $y ) = $self->_get_coord($radian);

#    $g->draw_line( $x, $y, $x, $y + $tick_height );
    

#}

sub _get_coord {
    my ( $self, $radian ) = @_;

    #my ($radius, $radian) = @_;
    my $x = $self->{cx} + ( $self->get_radius() * sin($radian) );
    my $y = $self->{cy} - ( $self->get_radius() * cos($radian) );
    return $x, $y;
}

sub _get_radian {
    my $self = shift;
    my ( $size, $position ) = @_;
    my $PI = 4 * atan2( 1, 1 );    #Get the value of PI
    return ( ( 360 / $size ) * $position ) * ( $PI / 180 );
}

=head2 draw_enzyme()

Describe your function here

 Usage   : 
 Args    : 
 Returns : 

=cut

sub draw_enzyme {
    my ( $self, @args ) = @_;

}

=head2 draw_marker()

Describe your function here

 Usage   : 
 Args    : 
 Returns : 

=cut

sub draw_marker {
    my ( $self, @args ) = @_;
    

}

=head1 SEE ALSO


=head1 COPYRIGHTS

Copyright (c) 2003 by Malay <curiouser@ccmb.res.in>. All rights reserved.

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=cut

1;
