# $Id: Plasmid.pm,v 1.3 2003/07/12 12:09:44 malay Exp $
# Perl module for BioSVG::Plasmid
# Author: Malay < curiouser@ccmb.res.in >
# Copyright (c) 2003 by Malay. All rights reserved.
# You may distribute this module under the same terms as perl itself

=head1 NAME

BioSVG::Plasmid - DESCRIPTION of Object

=head1 SYNOPSIS

Give standard usage here

=head1 DESCRIPTION

Describe the object here

=cut

package BioSVG::Plasmid;
@ISA = qw(Pastel::Exception Pastel::Mixin::Mixin);

#@EXPORT_OK = qw();
use Pastel::Mixin::Mixin;
use Pastel::Exception;
use Carp;
use strict;

=head1 CONSTRUCTOR

=cut

sub new {
    my ( $self, @args ) = @_;
    my ( $name, $size, $shape, $radius ) =
      Pastel::Mixin::Mixin->_rearrange( [ "NAME", "SIZE", "SHAPE", "RADIUS" ],
        @args );
    if ( !$name || !$size || !$shape ) {
        croak "Parameter missing in BioSVG::Plasmid::new()! \n";
    }
    my $plasmid;
    if ( $shape =~ /circular/i ) {
        $plasmid = BioSVG::CircularPlasmid->new( $name, $size );
	if ($radius) {
	    $plasmid->set_radius($radius);
	}else {
	    $plasmid->set_radius(150);
	}
    }
    else {
        $plasmid = BioSVG::LinearPlasmid->new( $name, $size );
    }

    $plasmid->set_backbone_font(
        Pastel::Font->new( "Myriad,Helvetica,Arial,Lucida", "bold", 11 ) );
    $plasmid->set_enzyme_font(
        Pastel::Font->new( "Myriad,Helvetica,Arial,Lucida", "regular", 9 ) );
    $plasmid->set_marker_font(
        Pastel::Font->new( "Myriad,Helvatica,Arial,Lucida", "bold", 11 ) );
    $plasmid->set_scale_font(
        Pastel::Font->new( "Myriad,Helvetica,Arial,Lucida", "regular", 7 ) );
    $plasmid->set_basic_color(Pastel::Color->black());
   
    $plasmid->set_basic_stroke(Pastel::BasicStroke->new());
    return $plasmid;
}

=head1 METHODS

=cut

sub set_basic_color{
    $_[0]->{basic_color} = $_[1];
}

sub get_basic_color{
    return $_[0]->{basic_color};
}
sub get_enzyme_iterator {
    my $self = shift;
    if ( @{ $self->{enzymes} } ) {
        return BioSVG::Plasmid::Iterator->new( $self->{enzymes} );
    }
    else {
        return undef;
    }
}

sub get_marker_iterator {

    my $self = shift;
    if ( @{ $self->{markers} } ) {
        return BioSVG::Plasmid::Iterator->new( $self->{markers} );
    }
    else {
        return undef;
    }
}

sub add_marker {
    my $self   = shift;
    my $marker = shift;
    if ($marker) {

        push @{ $self->{markers} }, $marker;
    }
}

sub add_enzyme {
    my ( $self, $ob ) = shift;
    if ($ob) {
        push @{ $self->{enzymes} }, $ob;
    }
}

sub set_font {
    my ( $self, $font ) = @_;
    $_[0]->{font} = $font;
}

sub get_font {
    return $_[0]->{font} ? $_[0]->{font} : undef;
}

sub set_backbone_font {
    $_[0]->{backbone_font} = $_[1];

}

sub get_backbone_font {
    return $_[0]->{backbone_font} ? $_[0]->{backbone_font} : undef;
}

sub set_enzyme_font {
    $_[0]->{enzyme_font} = $_[1];

}

sub get_enzyme_font {
    return $_[0]->{enzyme_font} ? $_[0]->{enzyme_font} : undef;
}

sub set_marker_font {
    $_[0]->{marker_font} = $_[1];

}

sub set_scale_font {
    $_[0]->{scale_font} = $_[1];
}

sub get_scale_font {
    return $_[0]->{scale_font} || undef;
}

sub get_marker_font {
    return $_[0]->{marker_font} ? $_[0]->{marker_font} : undef;
}

sub get_graphics {
    return $_[0]->{graphics};
}

sub add_backbone {
    my $self = shift;
#    my ( $stroke, $stroke_color, $font, $text_color ) =
#      Pastel::Mixin::Mixin->_rearrange;
}

sub get_backbone {
    return $_[0]->{backbone};
}

sub set_basic_stroke{
$_[0]->{basic_stroke} = $_[1];

}

sub get_basic_stroke{
return $_[0]->{basic_stroke};
}
=head2 get_name()

Describe your function here

 Usage   : 
 Args    : 
 Returns : 

=cut

sub get_name {
    return $_[0]->{name};

}

=head1 SEE ALSO


=head1 COPYRIGHTS

Copyright (c) 2003 by Malay <curiouser@ccmb.res.in>. All rights reserved.

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=cut

package BioSVG::Plasmid::Enzyme;

sub new {
    my ( $class, @args ) = @_;
    my $self = { (@args) };
    bless $self, ref $class || $class;
    return $self;
}

sub get_name {
    return $_[0]->{name};
}

sub get_position {
    return $_[0]->{position};
}

sub get_stroke {
    return $_[0]->{stroke} ? $_[0]->{stroke} : undef;

}

sub get_stroke_color {
    return $_[0]->{stroke_color} ? $_[0]->{stroke_color} : undef;
}

sub get_text_color {
    return $_[0]->{text_color} ? $_[0]->{text_color} : undef;
}


package BioSVG::Plasmid::Backbone;

sub new {

    my ( $class, @args ) = @_;
        #print STDERR "@args\n";
    my (%param )= (@args);
    my $self = \%param;
    bless $self, ref $class || $class;
    return $self;
}

sub get_width  {
    return $_[0]->{width} ? $_[0]->{width} : undef;

}

sub get_stroke_color {
    return $_[0]->{stroke_color} ? $_[0]->{stroke_color} : undef;
}

sub get_font {
    return $_[0]->{font} ? $_[0]->{font} : undef;
}

sub get_text_color {
    return $_[0]->{text_color} ? $_[0]->{text_color} : undef;
}

sub scale_on {
    my $self = shift;
    if ($self->{scale}) {
	return 1;
    }else {
	return 0;
    }
}
package BioSVG::Plasmid::Marker;

sub new {
    my ( $class, @args ) = @_;
    my $self = { (@args) };
    bless $self, ref $class || $class;
    return $self;
}

sub get_name {
    return $_[0]->{name};
}

sub get_stroke {
    return $_[0]->{stroke} ? $_[0]->{stroke} : undef;

}

sub get_stroke_color {
    return $_[0]->{stroke_color} ? $_[0]->{stroke_color} : undef;
}

sub get_text_color {
    return $_[0]->{text_color} ? $_[0]->{text_color} : undef;
}

sub get_style {
    return $_[0]->{style};
}

sub get_fill {
    return $_[0]->{fill};
}

sub get_start {
    return $_[0]->{start};
}
package BioSVG::Plasmid::Iterator;

sub new {
    my ( $class, $array_ref ) = @_;
    my $self = { index => 0, enzymes => $array_ref };
    bless $self, ref $class || $class;
    return $self;
}

sub has_more {
    my $self = shift;
    if ( defined( $self->{enzymes}[ $self->{index} ] ) ) {
        return 1;
    }
    else {
        return 0;
    }
}

sub next {
    my $self = shift;

    if ( my $ob = $self->{enzymes}[ $self->{index} ] ) {
        $self->{index}++;
        return $ob;
    }
    else {
        return undef;

    }
}
1;
