#use "topfind";;
#require "extlib";;
open ExtLib
open Printf
open Scanf
let dir = "w_1d";;
let files = Sys.readdir dir;;

let read file =
  fprintf stderr "# %s\n" file;
  let ic = open_in (Filename.concat dir file) in
  let ar = Array.of_list (input_list ic) in
  close_in ic;
  Array.map (fun l ->
    sscanf l " %f %f %f %f" (fun a b c d -> [|a; b; c; d|]))
    ar
  
(*let files = Array.sub files 0 1;;*)
let arrays = Array.map read files;;

let sum_array a b =
  let n = Array.length a in
  for i = 0 to n - 1 do
    let ai = a.(i) and bi = b.(i) in
    for j = 0 to 3 do
      ai.(j) <- ai.(j) +. bi.(j)
    done;
  done;
  a

let wave = Array.fold_left sum_array (Array.make_matrix 399 4 0.0) arrays;;

let w = 1.0 /. float (Array.length files);;
printf "double weights[][] = {\n";;
for i = 0 to 398 do
  printf "  {";
  for j = 0 to 3 do
    let a = wave.(i).(j) *. w in
    printf " %15.7e," a;
  done;
  printf " },\n";
done;
printf "};\n";;
