/*
 * Decompiled with CFR 0.152.
 */
package mclinterface;

import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout2;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import mclinterface.AboutFrame;
import mclinterface.ClassIO;
import mclinterface.Graphic;
import mclinterface.Graphic2;
import mclinterface.MclInterface;
import mclinterface.MyLink;
import mclinterface.MyNode;
import org.apache.commons.collections15.Transformer;

public class UserInterface
extends JFrame {
    private boolean apertoFile = false;
    private boolean salvatoFile = false;
    private boolean verificaMcl;
    private String indirizzo = "";
    private String cartella = "";
    private String viewOutput;
    private String comando = "";
    private JMenuBar menuBar;
    private ArrayList<JMenuItem> items = new ArrayList();
    private JMenu sottoReti;
    private boolean esci;
    private Graphic2 grp2;
    private int indexLayout = 1;
    private JMenuItem CircleLayout;
    private JMenuItem FRLayout;
    private JMenuItem ISOMLayout;
    private JMenuItem KKLayout;
    private JMenuItem SpringLayout;
    private JMenuItem SpringLayout2;
    private JMenuItem aboutMcl;
    private JButton addButton;
    public static JTextArea areaInput;
    private JTextArea areaOutput;
    private JMenuBar changeLayoutMenu;
    private JMenuItem chiudi;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JMenuItem mclManual;
    private JMenuItem newWindowButton;
    private JMenuItem openButton;
    private JMenuItem saveButton;
    private JButton startButton;
    private JButton viewInput;
    private JButton viewSubnet;

    public UserInterface() {
        this.initComponents();
        this.indexLayout = 1;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        areaInput = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.areaOutput = new JTextArea();
        this.startButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.viewInput = new JButton();
        this.jComboBox1 = new JComboBox();
        this.viewSubnet = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.jTextField2 = new JTextField();
        this.jComboBox2 = new JComboBox();
        this.addButton = new JButton();
        this.jTextField3 = new JTextField();
        this.changeLayoutMenu = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.newWindowButton = new JMenuItem();
        this.openButton = new JMenuItem();
        this.saveButton = new JMenuItem();
        this.chiudi = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenu3 = new JMenu();
        this.ISOMLayout = new JMenuItem();
        this.FRLayout = new JMenuItem();
        this.SpringLayout = new JMenuItem();
        this.SpringLayout2 = new JMenuItem();
        this.KKLayout = new JMenuItem();
        this.CircleLayout = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.aboutMcl = new JMenuItem();
        this.mclManual = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setPreferredSize(new Dimension(600, 600));
        this.jTextField1.setText("mcl input --abc -o output");
        this.jTextField1.setToolTipText("mcl command");
        this.jTextField1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                UserInterface.this.jTextField1KeyPressed(evt);
            }
        });
        areaInput.setColumns(20);
        areaInput.setRows(5);
        areaInput.setToolTipText("network of protein input");
        this.jScrollPane1.setViewportView(areaInput);
        this.areaOutput.setColumns(20);
        this.areaOutput.setEditable(false);
        this.areaOutput.setRows(5);
        this.areaOutput.setToolTipText("all subnets returned by mcl");
        this.jScrollPane2.setViewportView(this.areaOutput);
        this.startButton.setText("Start");
        this.startButton.setToolTipText("start analyzing the network of proteins");
        this.startButton.setEnabled(false);
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.startButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("OUTPUT");
        this.jLabel2.setText("INPUT");
        this.viewInput.setText("View Input");
        this.viewInput.setToolTipText("displays the graph of the network of protein input  ");
        this.viewInput.setEnabled(false);
        this.viewInput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.viewInputActionPerformed(evt);
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"subnet 1"}));
        this.jComboBox1.setToolTipText("choose which subnet display");
        this.jComboBox1.setEnabled(false);
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.viewSubnet.setText("View Subnet");
        this.viewSubnet.setToolTipText("displays the graph of the selected subnet");
        this.viewSubnet.setEnabled(false);
        this.viewSubnet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.viewSubnetActionPerformed(evt);
            }
        });
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setToolTipText("enable/disable the use of optional parameters");
        this.jCheckBox1.setEnabled(false);
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jTextField2.setToolTipText("inserts the value of optional parameter");
        this.jTextField2.setEnabled(false);
        this.jTextField2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.jTextField2ActionPerformed(evt);
            }
        });
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"P", "S", "R", "pct", "scheme", "I"}));
        this.jComboBox2.setToolTipText("optional parameters with default values");
        this.jComboBox2.setEnabled(false);
        this.jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.jComboBox2ActionPerformed(evt);
            }
        });
        this.addButton.setText("add");
        this.addButton.setToolTipText("adds the value of the parameter");
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.addButtonActionPerformed(evt);
            }
        });
        this.jTextField3.setEditable(false);
        this.jTextField3.setToolTipText("shows the selected subnet");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 845, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextField1, -1, 516, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1).addGap(11, 11, 11).addComponent(this.startButton, -2, 78, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.viewInput)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabel1)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBox1, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField3, -1, 679, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.viewSubnet)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 845, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -1, 32, Short.MAX_VALUE).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.addButton)).addGap(32, 32, 32).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.viewInput))).addGroup(jPanel1Layout.createSequentialGroup().addGap(27, 27, 27).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.startButton).addComponent(this.jCheckBox1)).addGap(75, 75, 75))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 167, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.jLabel1).addGap(64, 64, 64).addComponent(this.viewSubnet)).addGroup(jPanel1Layout.createSequentialGroup().addGap(58, 58, 58).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.jComboBox1, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 154, -2).addGap(23, 23, 23)));
        this.jMenu1.setText("File");
        this.newWindowButton.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newWindowButton.setText("New window");
        this.newWindowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.newWindowButtonActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.newWindowButton);
        this.openButton.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openButton.setText("Open");
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.openButtonActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.openButton);
        this.saveButton.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.saveButtonActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.saveButton);
        this.chiudi.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.chiudi.setText("Close");
        this.chiudi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.chiudiActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.chiudi);
        this.changeLayoutMenu.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenu3.setText("Change Layout");
        this.ISOMLayout.setText("ISOMLayout");
        this.ISOMLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.ISOMLayoutActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.ISOMLayout);
        this.FRLayout.setText("FRLayout");
        this.FRLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.FRLayoutActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.FRLayout);
        this.SpringLayout.setText("SpringLayout");
        this.SpringLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.SpringLayoutActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.SpringLayout);
        this.SpringLayout2.setText("SpringLayout2");
        this.SpringLayout2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.SpringLayout2ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.SpringLayout2);
        this.KKLayout.setText("KKLayout");
        this.KKLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.KKLayoutActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.KKLayout);
        this.CircleLayout.setText("CircleLayout");
        this.CircleLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.CircleLayoutActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.CircleLayout);
        this.jMenu2.add(this.jMenu3);
        this.changeLayoutMenu.add(this.jMenu2);
        this.jMenu4.setText("Help");
        this.aboutMcl.setText("About Mcl");
        this.aboutMcl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.aboutMclActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.aboutMcl);
        this.mclManual.setText("Mcl manual");
        this.mclManual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserInterface.this.mclManualActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mclManual);
        this.changeLayoutMenu.add(this.jMenu4);
        this.setJMenuBar(this.changeLayoutMenu);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, 869, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 618, -2).addContainerGap(24, Short.MAX_VALUE)));
        this.pack();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.salvatoFile = true;
        this.jCheckBox1.setEnabled(true);
        this.viewInput.setEnabled(true);
        if (this.jCheckBox1.isSelected()) {
            this.jComboBox2.setEnabled(true);
            this.jTextField2.setEnabled(true);
            this.addButton.setEnabled(true);
        }
        if (this.jCheckBox1.isSelected() && this.jTextField2.getText().equals("")) {
            this.startButton.setEnabled(false);
        }
        JFileChooser c = new JFileChooser();
        File currentDirectory = new File("./mclinterface/input_output");
        c.setCurrentDirectory(currentDirectory);
        int rVal = c.showSaveDialog(this);
        if (rVal == 0) {
            this.indirizzo = c.getSelectedFile().getAbsolutePath();
            this.cartella = c.getCurrentDirectory().toString();
            String n = this.indirizzo.substring(this.indirizzo.length() - 1);
            this.jTextField1.setText("mcl " + this.indirizzo + " --abc -o " + this.cartella + "/output" + n);
            this.comando = this.jTextField1.getText();
            String areaTextInput = areaInput.getText();
            ClassIO.writeFile(this.indirizzo, areaTextInput);
        }
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.apertoFile = true;
        this.jCheckBox1.setEnabled(true);
        this.viewInput.setEnabled(true);
        if (this.areaOutput.getText() != null) {
            this.jComboBox1.setEnabled(false);
            this.viewSubnet.setEnabled(false);
        }
        if (this.jCheckBox1.isSelected()) {
            this.jComboBox2.setEnabled(true);
            this.jTextField2.setEnabled(true);
            this.addButton.setEnabled(true);
        }
        if (this.jCheckBox1.isSelected() && this.jTextField2.getText().equals("")) {
            this.startButton.setEnabled(false);
        }
        JFileChooser c = new JFileChooser();
        File currentDirectory = new File("./mclinterface/input_output");
        c.setCurrentDirectory(currentDirectory);
        int rVal = c.showOpenDialog(this);
        if (rVal == 0) {
            this.indirizzo = c.getSelectedFile().getAbsolutePath();
            this.cartella = c.getCurrentDirectory().toString();
            String n = this.indirizzo.substring(this.indirizzo.length() - 1);
            this.jTextField1.setText("mcl " + this.indirizzo + " --abc -o " + this.cartella + "/output" + n);
            this.comando = this.jTextField1.getText();
            ClassIO.readFile(this.indirizzo, areaInput);
        }
        if (rVal == 1) {
            // empty if block
        }
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        if (this.apertoFile || this.salvatoFile) {
            this.jComboBox1.setEnabled(true);
            this.viewSubnet.setEnabled(true);
            this.start();
        }
    }

    private void jTextField1KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && (this.apertoFile || this.salvatoFile)) {
            this.jComboBox1.setEnabled(true);
            this.viewSubnet.setEnabled(true);
            this.start();
        }
    }

    private void chiudiActionPerformed(ActionEvent evt) {
        System.exit(-1);
    }

    private void viewInputActionPerformed(ActionEvent evt) {
        Graphic grp = new Graphic(this.indirizzo);
        if (this.indexLayout == 1) {
            grp.viewGraph();
        } else {
            if (this.indexLayout == 2) {
                grp.viewGraph((Layout<MyNode, MyLink>)new FRLayout(grp.g));
            }
            if (this.indexLayout == 3) {
                grp.viewGraph((Layout<MyNode, MyLink>)new SpringLayout(grp.g));
            }
            if (this.indexLayout == 4) {
                grp.viewGraph((Layout<MyNode, MyLink>)new SpringLayout2(grp.g));
            }
            if (this.indexLayout == 5) {
                grp.viewGraph((Layout<MyNode, MyLink>)new KKLayout(grp.g));
            }
            if (this.indexLayout == 6) {
                grp.viewGraph((Layout<MyNode, MyLink>)new CircleLayout(grp.g));
            }
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        int index = this.jComboBox1.getSelectedIndex();
        this.cerca(index);
        this.jTextField3.setText(this.viewOutput);
    }

    private String cerca(int index) {
        String n = this.indirizzo.substring(this.indirizzo.length() - 1);
        String outputFile = this.cartella + "/output" + n;
        this.viewOutput = ClassIO.searchSubnet(outputFile, index);
        return this.viewOutput;
    }

    private void viewSubnetActionPerformed(ActionEvent evt) {
        this.items.removeAll(this.items);
        int index = this.jComboBox1.getSelectedIndex();
        this.cerca(index);
        this.viewOutput(this.viewOutput, true);
    }

    private void viewOutput(String rete, boolean viewSubnet) {
        this.grp2 = new Graphic2(rete);
        Object layout = new ISOMLayout(this.grp2.g);
        if (this.indexLayout == 2) {
            layout = new FRLayout(this.grp2.g);
        }
        if (this.indexLayout == 3) {
            layout = new SpringLayout(this.grp2.g);
        }
        if (this.indexLayout == 4) {
            layout = new SpringLayout2(this.grp2.g);
        }
        if (this.indexLayout == 5) {
            layout = new KKLayout(this.grp2.g);
        }
        layout = this.indexLayout == 6 ? new CircleLayout(this.grp2.g) : new ISOMLayout(this.grp2.g);
        layout.setSize(new Dimension(650, 650));
        VisualizationViewer vv = new VisualizationViewer((Layout)layout);
        vv.setPreferredSize(new Dimension(800, 800));
        vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        vv.getRenderContext().setEdgeLabelTransformer((Transformer)new ToStringLabeller());
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        vv.addKeyListener(gm.getModeKeyListener());
        this.menuBar = new JMenuBar();
        JMenu modeMenu = gm.getModeMenu();
        modeMenu.setText("Mouse Mode");
        modeMenu.setIcon(null);
        modeMenu.setPreferredSize(new Dimension(120, 20));
        if (viewSubnet) {
            this.sottoReti = new JMenu("Subnets");
            this.sottoReti.setPreferredSize(new Dimension(100, 20));
            int numSottoreti = this.jComboBox1.getItemCount();
            for (int i = 0; i < numSottoreti; ++i) {
                int num = i + 1;
                this.updateGui("subnet " + num);
            }
            this.menuBar.add(this.sottoReti);
        }
        this.menuBar.add(modeMenu);
        JFrame frame = new JFrame("Proteins Graphic View");
        frame.setJMenuBar(this.menuBar);
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add((Component)vv);
        frame.pack();
        frame.setVisible(true);
    }

    public void updateGui(String nomeItem) {
        JMenuItem item = new JMenuItem(nomeItem);
        this.sottoReti.add(item);
        this.items.add(item);
        this.esci = false;
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (int i = 0; i < UserInterface.this.items.size() && !UserInterface.this.esci; ++i) {
                    JMenuItem itemCorr = (JMenuItem)UserInterface.this.items.get(i);
                    if (!itemCorr.equals(evt.getSource())) continue;
                    String rete = UserInterface.this.cerca(i);
                    UserInterface.this.viewOutput(rete, false);
                }
            }
        });
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (!this.jCheckBox1.isSelected()) {
            this.jComboBox2.setEnabled(false);
            this.jTextField2.setEnabled(false);
            this.addButton.setEnabled(false);
            this.startButton.setEnabled(true);
            this.jTextField1.setText(this.comando);
        } else {
            this.jComboBox2.setEnabled(true);
            this.jTextField2.setEnabled(true);
            this.addButton.setEnabled(true);
        }
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        int index = this.jComboBox2.getSelectedIndex();
        String n = this.indirizzo.substring(this.indirizzo.length() - 1);
        String numero = this.jTextField2.getText();
        if (index == 0) {
            this.jTextField1.setText("mcl " + this.indirizzo + " --abc -P " + 4000 + " -o " + this.cartella + "/output" + n);
            this.jTextField2.setText("4000");
        }
        if (index == 1) {
            this.jTextField1.setText("mcl " + this.indirizzo + " --abc -S " + 500 + " -o " + this.cartella + "/output" + n);
            this.jTextField2.setText("500");
        }
        if (index == 2) {
            this.jTextField1.setText("mcl " + this.indirizzo + " --abc -R " + 600 + " -o " + this.cartella + "/output" + n);
            this.jTextField2.setText("600");
        }
        if (index == 3) {
            this.jTextField1.setText("mcl " + this.indirizzo + " --abc -pct " + 95 + " -o " + this.cartella + "/output" + n);
            this.jTextField2.setText("95");
        }
        if (index == 4) {
            this.jTextField1.setText("mcl " + this.indirizzo + " --abc -scheme " + 4 + " -o " + this.cartella + "/output" + n);
            this.jTextField2.setText("4");
        }
        if (index == 5) {
            this.jTextField1.setText("mcl " + this.indirizzo + " --abc -I " + 1.2 + " -o " + this.cartella + "/output" + n);
            this.jTextField2.setText("1.2");
        }
        this.startButton.setEnabled(true);
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
        int index = this.jComboBox2.getSelectedIndex();
        String n = this.indirizzo.substring(this.indirizzo.length() - 1);
        String numero = this.jTextField2.getText();
        try {
            double x = Double.parseDouble(numero);
            if (index == 0) {
                this.jTextField1.setText("mcl " + this.indirizzo + " --abc -P " + numero + " -o " + this.cartella + "/output" + n);
            }
            if (index == 1) {
                this.jTextField1.setText("mcl " + this.indirizzo + " --abc -S " + numero + " -o " + this.cartella + "/output" + n);
            }
            if (index == 2) {
                this.jTextField1.setText("mcl " + this.indirizzo + " --abc -R " + numero + " -o " + this.cartella + "/output" + n);
            }
            if (index == 3) {
                this.jTextField1.setText("mcl " + this.indirizzo + " --abc -pct " + numero + " -o " + this.cartella + "/output" + n);
            }
            if (index == 4) {
                this.jTextField1.setText("mcl " + this.indirizzo + " --abc -scheme " + numero + " -o " + this.cartella + "/output" + n);
            }
            if (index == 5) {
                this.jTextField1.setText("mcl " + this.indirizzo + " --abc -I " + numero + " -o " + this.cartella + "/output" + n);
            }
            if (!numero.equals("")) {
                this.startButton.setEnabled(true);
            }
            if (numero.equals("")) {
                this.startButton.setEnabled(false);
            }
        }
        catch (Exception e) {
            this.jTextField2.setText("Error");
            this.startButton.setEnabled(false);
        }
    }

    private void ISOMLayoutActionPerformed(ActionEvent evt) {
        this.indexLayout = 1;
    }

    private void FRLayoutActionPerformed(ActionEvent evt) {
        this.indexLayout = 2;
    }

    private void SpringLayout2ActionPerformed(ActionEvent evt) {
        this.indexLayout = 4;
    }

    private void CircleLayoutActionPerformed(ActionEvent evt) {
        this.indexLayout = 6;
    }

    private void newWindowButtonActionPerformed(ActionEvent evt) {
        new UserInterface().setVisible(true);
    }

    private void mclManualActionPerformed(ActionEvent evt) {
        try {
            Process p = Runtime.getRuntime().exec("ooffice -writer ./mclinterface/mcl.odt");
        }
        catch (IOException ex) {
            Logger.getLogger(UserInterface.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.jTextField2ActionPerformed(evt);
    }

    private void aboutMclActionPerformed(ActionEvent evt) {
        new AboutFrame().setVisible(true);
    }

    private void SpringLayoutActionPerformed(ActionEvent evt) {
        this.indexLayout = 3;
    }

    private void KKLayoutActionPerformed(ActionEvent evt) {
        this.indexLayout = 5;
    }

    private void start() {
        String n = this.indirizzo.substring(this.indirizzo.length() - 1);
        this.verificaMcl = MclInterface.mcl(this.jTextField1.getText());
        if (this.verificaMcl) {
            this.jComboBox1.removeAllItems();
            this.jComboBox1.addItem("subnet 1");
            String outputFile = this.cartella + "/output" + n;
            ClassIO.readFile(outputFile, this.areaOutput, this.jComboBox1);
        } else {
            this.areaOutput.setText("Mcl error! Mcl is not installed or is not configured correctly. Please check your Mcl version or the command in the command bar.");
        }
    }
}

