/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraph<V, E>
implements Graph<V, E> {
    @Override
    public boolean addEdge(E edge, Collection<? extends V> vertices) {
        return this.addEdge(edge, (V)vertices, (V)((Object)this.getDefaultEdgeType()));
    }

    @Override
    public boolean addEdge(E edge, Collection<? extends V> vertices, EdgeType edgeType) {
        if (vertices == null) {
            throw new IllegalArgumentException("'vertices' parameter must not be null");
        }
        if (vertices.size() == 2) {
            return this.addEdge(edge, vertices instanceof Pair ? (Pair<Object>)vertices : new Pair<V>(vertices), edgeType);
        }
        if (vertices.size() == 1) {
            V vertex = vertices.iterator().next();
            return this.addEdge(edge, new Pair<V>(vertex, vertex), edgeType);
        }
        throw new IllegalArgumentException("Graph objects connect 1 or 2 vertices; vertices arg has " + vertices.size());
    }

    @Override
    public boolean addEdge(E e, V v1, V v2) {
        return this.addEdge(e, v1, v2, this.getDefaultEdgeType());
    }

    @Override
    public boolean addEdge(E e, V v1, V v2, EdgeType edge_type) {
        return this.addEdge(e, new Pair<V>(v1, v2), edge_type);
    }

    @Override
    public boolean addEdge(E edge, Pair<? extends V> endpoints) {
        return this.addEdge(edge, endpoints, this.getDefaultEdgeType());
    }

    @Override
    public abstract boolean addEdge(E var1, Pair<? extends V> var2, EdgeType var3);

    protected Pair<V> getValidatedEndpoints(E edge, Pair<? extends V> endpoints) {
        if (edge == null) {
            throw new IllegalArgumentException("input edge may not be null");
        }
        if (endpoints == null) {
            throw new IllegalArgumentException("endpoints may not be null");
        }
        Pair<V> new_endpoints = new Pair<V>(endpoints.getFirst(), endpoints.getSecond());
        if (this.containsEdge(edge)) {
            Pair existing_endpoints = this.getEndpoints(edge);
            if (!existing_endpoints.equals(new_endpoints)) {
                throw new IllegalArgumentException("edge " + edge + " already exists in this graph with endpoints " + existing_endpoints + " and cannot be added with endpoints " + endpoints);
            }
            return null;
        }
        return new_endpoints;
    }

    @Override
    public int inDegree(V vertex) {
        return this.getInEdges(vertex).size();
    }

    @Override
    public int outDegree(V vertex) {
        return this.getOutEdges(vertex).size();
    }

    @Override
    public boolean isPredecessor(V v1, V v2) {
        return this.getPredecessors(v1).contains(v2);
    }

    @Override
    public boolean isSuccessor(V v1, V v2) {
        return this.getSuccessors(v1).contains(v2);
    }

    @Override
    public int getPredecessorCount(V vertex) {
        return this.getPredecessors(vertex).size();
    }

    @Override
    public int getSuccessorCount(V vertex) {
        return this.getSuccessors(vertex).size();
    }

    @Override
    public boolean isNeighbor(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            throw new IllegalArgumentException("At least one of these not in this graph: " + v1 + ", " + v2);
        }
        return this.getNeighbors(v1).contains(v2);
    }

    @Override
    public boolean isIncident(V vertex, E edge) {
        if (!this.containsVertex(vertex) || !this.containsEdge(edge)) {
            throw new IllegalArgumentException("At least one of these not in this graph: " + vertex + ", " + edge);
        }
        return this.getIncidentEdges(vertex).contains(edge);
    }

    @Override
    public int getNeighborCount(V vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException(vertex + " is not a vertex in this graph");
        }
        return this.getNeighbors(vertex).size();
    }

    @Override
    public int degree(V vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException(vertex + " is not a vertex in this graph");
        }
        return this.getIncidentEdges(vertex).size();
    }

    @Override
    public int getIncidentCount(E edge) {
        Pair incident = this.getEndpoints(edge);
        if (incident == null) {
            return 0;
        }
        if (incident.getFirst() == incident.getSecond()) {
            return 1;
        }
        return 2;
    }

    @Override
    public V getOpposite(V vertex, E edge) {
        Pair incident = this.getEndpoints(edge);
        Object first = incident.getFirst();
        Object second = incident.getSecond();
        if (vertex.equals(first)) {
            return second;
        }
        if (vertex.equals(second)) {
            return first;
        }
        throw new IllegalArgumentException(vertex + " is not incident to " + edge + " in this graph");
    }

    @Override
    public E findEdge(V v1, V v2) {
        for (Object e : this.getOutEdges(v1)) {
            if (!this.getOpposite(v1, e).equals(v2)) continue;
            return e;
        }
        return null;
    }

    @Override
    public Collection<E> findEdgeSet(V v1, V v2) {
        if (!this.getVertices().contains(v1)) {
            throw new IllegalArgumentException(v1 + " is not an element of this graph");
        }
        if (!this.getVertices().contains(v2)) {
            throw new IllegalArgumentException(v2 + " is not an element of this graph");
        }
        ArrayList edges = new ArrayList();
        for (Object e : this.getOutEdges(v1)) {
            if (!this.getOpposite(v1, e).equals(v2)) continue;
            edges.add(e);
        }
        return Collections.unmodifiableCollection(edges);
    }

    @Override
    public Collection<V> getIncidentVertices(E edge) {
        Pair endpoints = this.getEndpoints(edge);
        ArrayList incident = new ArrayList();
        incident.add(endpoints.getFirst());
        incident.add(endpoints.getSecond());
        return Collections.unmodifiableCollection(incident);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Vertices:");
        for (Object v : this.getVertices()) {
            sb.append(v + ",");
        }
        sb.setLength(sb.length() - 1);
        sb.append("\nEdges:");
        for (Object e : this.getEdges()) {
            Pair ep = this.getEndpoints(e);
            sb.append(e + "[" + ep.getFirst() + "," + ep.getSecond() + "] ");
        }
        return sb.toString();
    }
}

