/*
 * Decompiled with CFR 0.152.
 */
package mclinterface;

import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import mclinterface.MyLink;
import mclinterface.MyNode;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graphic {
    Graph<MyNode, MyLink> g = new SparseMultigraph();
    private int num = 0;
    private String token;
    private ArrayList<MyNode> listaMyNode = new ArrayList();
    private ArrayList<String> listaLink = new ArrayList();
    private JMenuBar menuBar;

    public Graphic(String file) {
        File f = new File(file);
        try {
            FileInputStream fis = new FileInputStream(f);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                StringTokenizer str = new StringTokenizer(line);
                while (str.hasMoreTokens()) {
                    this.token = str.nextToken();
                    this.listaLink.add(this.token);
                    ++this.num;
                    MyNode nodo = new MyNode(this.num, this.token);
                    if (this.listaMyNode.contains(nodo)) continue;
                    this.listaMyNode.add(nodo);
                    this.g.addVertex((Object)nodo);
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        MyNode myNode1 = new MyNode();
        MyNode myNode2 = new MyNode();
        for (int i = 0; i < this.listaLink.size(); i += 2) {
            String nomeProteina1 = this.listaLink.get(i);
            String nomeProteina2 = this.listaLink.get(i + 1);
            for (int j = 0; j < this.listaMyNode.size(); ++j) {
                MyNode node = this.listaMyNode.get(j);
                if (node.getNome().equals(nomeProteina1)) {
                    myNode1 = node;
                }
                if (!node.getNome().equals(nomeProteina2)) continue;
                myNode2 = node;
            }
            this.g.addEdge((Object)new MyLink(1.0), (Object)myNode1, (Object)myNode2);
        }
    }

    public void viewGraph() {
        ISOMLayout layout = new ISOMLayout(this.g);
        layout.setSize(new Dimension(650, 650));
        VisualizationViewer vv = new VisualizationViewer((Layout)layout);
        vv.setPreferredSize(new Dimension(800, 800));
        vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        vv.getRenderContext().setEdgeLabelTransformer((Transformer)new ToStringLabeller());
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        vv.addKeyListener(gm.getModeKeyListener());
        this.menuBar = new JMenuBar();
        JMenu modeMenu = gm.getModeMenu();
        modeMenu.setText("Mouse Mode");
        modeMenu.setIcon(null);
        modeMenu.setPreferredSize(new Dimension(120, 20));
        this.menuBar.add(modeMenu);
        JFrame frame = new JFrame("Proteins Graphic View");
        frame.setJMenuBar(this.menuBar);
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add((Component)vv);
        frame.pack();
        frame.setVisible(true);
    }

    public void viewGraph(Layout<MyNode, MyLink> layout) {
        layout.setSize(new Dimension(650, 650));
        VisualizationViewer vv = new VisualizationViewer(layout);
        vv.setPreferredSize(new Dimension(800, 800));
        vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        vv.getRenderContext().setEdgeLabelTransformer((Transformer)new ToStringLabeller());
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        vv.addKeyListener(gm.getModeKeyListener());
        this.menuBar = new JMenuBar();
        JMenu modeMenu = gm.getModeMenu();
        modeMenu.setText("Mouse Mode");
        modeMenu.setIcon(null);
        modeMenu.setPreferredSize(new Dimension(120, 20));
        this.menuBar.add(modeMenu);
        JFrame frame = new JFrame("Proteins Graphic View");
        frame.setJMenuBar(this.menuBar);
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add((Component)vv);
        frame.pack();
        frame.setVisible(true);
    }
}

