datacache <- new.env(hash=TRUE, parent=emptyenv())

hgu133bhsentrezg <- function() showQCData("hgu133bhsentrezg", datacache)
hgu133bhsentrezg_dbconn <- function() dbconn(datacache)
hgu133bhsentrezg_dbfile <- function() dbfile(datacache)
hgu133bhsentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hgu133bhsentrezg_dbInfo <- function() dbInfo(datacache)

hgu133bhsentrezgORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hgu133bhsentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hgu133bhsentrezg", "chip hgu133bhsentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hgu133bhsentrezg_dbconn())
}

