datacache <- new.env(hash=TRUE, parent=emptyenv())

mgu74cv2mmentrezg <- function() showQCData("mgu74cv2mmentrezg", datacache)
mgu74cv2mmentrezg_dbconn <- function() dbconn(datacache)
mgu74cv2mmentrezg_dbfile <- function() dbfile(datacache)
mgu74cv2mmentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mgu74cv2mmentrezg_dbInfo <- function() dbInfo(datacache)

mgu74cv2mmentrezgORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mgu74cv2mmentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mgu74cv2mmentrezg", "chip mgu74cv2mmentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mgu74cv2mmentrezg_dbconn())
}

