
\name{moe430ammentrezg_dbconn}

\alias{moe430ammentrezg_dbconn}
\alias{moe430ammentrezg_dbfile}
\alias{moe430ammentrezg_dbschema}
\alias{moe430ammentrezg_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  moe430ammentrezg_dbconn()
  moe430ammentrezg_dbfile()
  moe430ammentrezg_dbschema(file="", show.indices=FALSE)
  moe430ammentrezg_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{moe430ammentrezg_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{moe430ammentrezg_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{moe430ammentrezg_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{moe430ammentrezg_dbschema} prints the schema definition of the
  package annotation DB.

  \code{moe430ammentrezg_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{moe430ammentrezg_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{moe430ammentrezg_dbfile}: a character string with the path to the
  package annotation DB.

  \code{moe430ammentrezg_dbschema}: none (invisible \code{NULL}).

  \code{moe430ammentrezg_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(moe430ammentrezg_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by moe430ammentrezg_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=moe430ammentrezg_dbfile(), cache_size=64000,
  synchronous=0)

  moe430ammentrezg_dbschema()

  moe430ammentrezg_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

