\name{raex10stv1rnrefseqPMID}
\alias{raex10stv1rnrefseqPMID}
\title{Map between Manufacturer Identifiers and PubMed Identifiers}
\description{
   raex10stv1rnrefseqPMID is an R object that provides mappings between
   manufacturer identifiers and PubMed identifiers.
}
\details{
  Each manufacturer identifier is mapped to a named vector of PubMed identifiers. The
  name associated with each vector corresponds to the manufacturer
  identifier. The length of the vector may be one or greater, depending on how
  many PubMed identifiers a given manufacturer identifier is mapped to. An \code{NA} is
  reported for any manufacturer identifier that cannot be mapped to a PubMed identifier.

  Titles, abstracts, and possibly full texts of articles can be obtained
  from PubMed by providing a valid PubMed identifier. The pubmed function of
  annotate can also be used for the same purpose.

  Mappings were based on data provided by: Entrez Gene  
  ftp://ftp.ncbi.nlm.nih.gov/gene/DATA  
  With a date stamp from the source of: 2010-Mar1

}
\references{
  \url{http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=PubMed}
}
\examples{
        x <- raex10stv1rnrefseqPMID
        # Get the probe identifiers that are mapped to any PubMed ID
        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
    if(length(xx) > 0){
        # Get the PubMed identifiers for the first two probe identifiers
        xx[1:2]
        # Get the first one
        xx[[1]]
        if(interactive() && !is.null(xx[[1]]) && !is.na(xx[[1]])
           && require(annotate)){
            # Get article information as XML files
            xmls <- pubmed(xx[[1]], disp = "data")
            # View article information using a browser
            pubmed(xx[[1]], disp = "browser")
        }
    }
}
\keyword{datasets}

