datacache <- new.env(hash=TRUE, parent=emptyenv())

moe430bmmrefseq <- function() showQCData("moe430bmmrefseq", datacache)
moe430bmmrefseq_dbconn <- function() dbconn(datacache)
moe430bmmrefseq_dbfile <- function() dbfile(datacache)
moe430bmmrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
moe430bmmrefseq_dbInfo <- function() dbInfo(datacache)

moe430bmmrefseqORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "moe430bmmrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "moe430bmmrefseq", "chip moe430bmmrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(moe430bmmrefseq_dbconn())
}

