datacache <- new.env(hash=TRUE, parent=emptyenv())

hgu95ahsentrezg <- function() showQCData("hgu95ahsentrezg", datacache)
hgu95ahsentrezg_dbconn <- function() dbconn(datacache)
hgu95ahsentrezg_dbfile <- function() dbfile(datacache)
hgu95ahsentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hgu95ahsentrezg_dbInfo <- function() dbInfo(datacache)

hgu95ahsentrezgORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hgu95ahsentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hgu95ahsentrezg", "chip hgu95ahsentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hgu95ahsentrezg_dbconn())
}

