datacache <- new.env(hash=TRUE, parent=emptyenv())

hgfocushsrefseq <- function() showQCData("hgfocushsrefseq", datacache)
hgfocushsrefseq_dbconn <- function() dbconn(datacache)
hgfocushsrefseq_dbfile <- function() dbfile(datacache)
hgfocushsrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hgfocushsrefseq_dbInfo <- function() dbInfo(datacache)

hgfocushsrefseqORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hgfocushsrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hgfocushsrefseq", "chip hgfocushsrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hgfocushsrefseq_dbconn())
}

