\name{getI_ProbeSets}
\alias{getI_ProbeSets}
\title{Method to generate a vector of informative probe set names}
\description{
  This function generates an  instance of   \code{\link[base]{vector-class}}, that return a vector of  informative probe set names.
}
\usage{
          getI_ProbeSets(object)
          }
\arguments{
    	\item{object}{An instance of \code{\link[farms]{INIcalls-class}}.}
          }
\value{\code{\link[base]{vector-class}}}
\seealso{\code{\link{exp.farms}}, \code{\link{q.farms}},\code{\link{l.farms}},\code{\link{INIcalls}},\code{\link{summary}}}
\examples{
  data(Dilution) 
  eset <- exp.farms(Dilution, bgcorrect.method = "rma", pmcorrect.method = "pmonly", normalize.method = "constant")  
  INIs <- INIcalls(eset)  # apply I/NI calls
  summary(INIs)  
  plotINIs(INIs) # draws a density plot of I/NI-calls
  I_data <- getI_Eset(INIs) # affybatch containing only  informative probe sets
  NI_data <- getNI_Eset(INIs) # affybatch containing only  non-informative probe sets
  I_probes <- getI_ProbeSets(INIs) # vector containing only  informative probe sets names
  NI_probes <- getNI_ProbeSets(INIs) # vector containing only  non-informative probe sets names
}
\keyword{manip}

