datacache <- new.env(hash=TRUE, parent=emptyenv())

rat2302rnentrezg <- function() showQCData("rat2302rnentrezg", datacache)
rat2302rnentrezg_dbconn <- function() dbconn(datacache)
rat2302rnentrezg_dbfile <- function() dbfile(datacache)
rat2302rnentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
rat2302rnentrezg_dbInfo <- function() dbInfo(datacache)

rat2302rnentrezgORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "rat2302rnentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "rat2302rnentrezg", "chip rat2302rnentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(rat2302rnentrezg_dbconn())
}

