######## Detection of differentially expressed genes ##########

Limma.1wayblock<-function(Factor,Block,contrast)
{
	lencontrast=length(contrast);
#Find the fold change
	FL1=factor(data.info[,Factor]);
	FL2=factor(data.info[,Block]);
	out.fc=data.frame();
	for(i in 1: lencontrast)
	{
		tmp=unlist(strsplit(contrast[[i]],"_VS_"))
		case=tmp[1];control=tmp[2];
		group.case=(FL1==case)
		group.control=(FL1==control)
		out.tmp=FindFC(exprs(data.eset)[,group.case],exprs(data.eset)[,group.control]);
		out.tmp=as.data.frame(out.tmp)
		colnames(out.tmp)=paste(contrast[[i]],colnames(out.tmp),sep="_")
		if(i==1) 
		{
			out.fc=out.tmp;
		}else{
			out.fc=cbind(out.fc,out.tmp);
		}
	}
	ID=rownames(out.fc);
	out.fc=cbind(ID,out.fc)
	colnames(out.fc)[1]=c("PROBEID")

#Find the Adjust P.Value From Limma

# Make the design Matri
	design=model.matrix(~0+FL1+FL2)
	colnames(design)=c(levels(FL1),levels(FL2)[-1])
#make the contrast
	level=colnames(design);
	contrast.matrix=matrix(0,nrow=length(level),ncol=lencontrast)
	rownames(contrast.matrix)=level
	for(i in 1: lencontrast)
	{
		tmp=unlist(strsplit(contrast[[i]],"_VS_"))
		case=tmp[1];control=tmp[2];
		contrast.matrix[level==case,i]=1
		contrast.matrix[level==control,i]=-1
	}
# Fit the model
	fit= lmFit(data.eset,design)
#Apply the contrast and Find the P-value
	fit2=contrasts.fit(fit,contrast.matrix)
	fit2=eBayes(fit2)
#Output the result
	Limma.out=data.frame();
	for(i in 1:lencontrast)
	{
		tmp.Limma.out=topTable(fit2,coef=i,adjust="fdr",number=Inf,sort.by="none")
		colnames(tmp.Limma.out)[1]="PROBEID";
		#tmp.Limma.out=tmp.Limma.out[order(tmp.Limma.out[,"PROBEID"]),]
		colnames(tmp.Limma.out)=paste(contrast[[i]],colnames(tmp.Limma.out),sep="_")
		if(i==1) 
		{	
			Limma.out=as.data.frame(tmp.Limma.out);
		}else{
			Limma.out=cbind(Limma.out,as.data.frame(tmp.Limma.out)[,-1]);
		}
	}
	colnames(Limma.out)[1]="PROBEID";
	out=merge(out.fc,Limma.out,by="PROBEID")
	return(out)
}

Limma1wayBlock<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<10)
	{
		tkmessageBox(message="Please Finish the previous step!");
		tkfocus(tt);return();
	}

	tkconfigure(tt,cursor="watch")

	an=Input.Limma.1wayblock();
	if(as.numeric(an$ReturnValue)!=1) {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}
	Factor=an$Selfac;
	Block=an$Selblock;
	contrast=an$contrast;
	tmp.out=Limma.1wayblock(Factor,Block,contrast);
	tmp.name<<-paste("Limma.1wayBlock","Factor",Factor,"Block",Block,sep="_")
	out<<-list(tmp.out,tmp.name,"limma",contrast)
	names(out)<<-c("result","name","type","contrast")
	UpStage(12,"Limma.1wayblock");
	tkmessageBox(message="Differential gene expression Completed!")
	tkconfigure(tt,cursor="arrow")

})

	tkfocus(tt);
}


