RankProd2Group<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<10)
	{
		tkmessageBox(message="Please Finish the previous step!");
		tkfocus(tt);return();
	}
	tkconfigure(tt,cursor="watch")

# Select Case and Control 
	an=Input.RankProd2Group(); 
	if(as.numeric(an$ReturnValue)!=1) {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}

#data prepare
	list.value=data.info[,an$Selfac]
	index.case=grepl(an$case,list.value);
	index.control=grepl(an$control,list.value);
	sample.sel=index.case | index.control;

	data=exprs(data.eset)[,sample.sel]
	data.cl=array(0,sum(sample.sel));
	data.cl[match(which(index.case),which(sample.sel))]=1;
	data.cl[match(which(index.control),which(sample.sel))]=0;

#Find the fold change
	case=exprs(data.eset)[,index.case]; 
	control=exprs(data.eset)[,index.control];
	out.fc=as.data.frame(FindFC(case,control));
	ID=rownames(out.fc);
	out.fc=cbind(ID,out.fc)
	colnames(out.fc)[1]=c("PROBEID");

# Find P-value From RP

	RP.out=RP(data,data.cl,num.perm=as.numeric(an$PermNum),logged = TRUE,
		na.rm = FALSE, plot = FALSE, rand = 123)
	out.RP=as.data.frame(cbind(apply(RP.out$pfp,1,min),apply(RP.out$pval,1,min)));
	colnames(out.RP)=c("adj.P.Val","P.Value")
# combine the result from Pvalue and FC
	tmp.out=cbind(out.fc,out.RP);
	tmp.name=paste("RankProduct",an$Selfac,an$case,"vs",an$control,sep="_")
	out<<-list(tmp.out,tmp.name,"rankprod")
	names(out)<<-c("result","name","type")
	UpStage(12,"RankProd2Group");
	tkconfigure(tt,cursor="arrow");
	tkfocus(tt);
});

}