#SAM

SAM.Unpaired<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<10)
	{
		tkmessageBox(message="Please Finish the previous step!");
		tkfocus(tt);return();
	}
	tkconfigure(tt,cursor="watch")
	list.factor=colnames(data.info);

# Select Case and Control 
	an=Input.SAM.Unpaired(); 
	if(as.numeric(an$ReturnValue)!=1) {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}
	
#data prepare
	list.value=data.info[,an$Selfac]
	index.case=grepl(an$case,list.value);
	index.control=grepl(an$control,list.value);
	sample.sel=index.case | index.control;

	data=exprs(data.eset)[,sample.sel]
	data.cl=array(0,sum(sample.sel));
	data.cl[match(which(index.case),which(sample.sel))]=1;

#Find the fold change
	case=exprs(data.eset)[,index.case]; 
	control=exprs(data.eset)[,index.control];
	out.fc=as.data.frame(FindFC(case,control));
	ID=rownames(out.fc);
	out.fc=cbind(ID,out.fc)
	colnames(out.fc)[1]=c("PROBEID");
	
	if(an$Selmethod=="wilc.stat")
	{
		sam.out=sam(data,data.cl,method=an$Selmethod,rand=123);
		output=as.data.frame(cbind(sam.out@d,sam.out@p.value,sam.out@q.value));
		colnames(output)=c("Dscore","P.Value","Q.Value");
	}else{
		sam.out=sam(data,data.cl,method=an$Selmethod,rand=123,B=as.numeric(an$PermNum));	
		output=as.data.frame(cbind(sam.out@d,sam.out@s,sam.out@p.value,sam.out@q.value));
		colnames(output)=c("Dscore","SD","P.Value","Q.Value");
	}

	output=cbind(rownames(output),output);
	colnames(output)[1]="PROBEID";

	#de=findDelta(sam.out,fdr=0.1)[2]
	#ss=which(names(sam.out@p.value)=="1443772_at")
	#summary(sam.out,de)@row.sig.genes[ss]
	#output=summary(sam.out,de)@mat.sig; #[,c("rawp","q.value","R.fold")]

#Output the result

	tmp.out=merge(out.fc,output,by="PROBEID");
	tmp.name=paste("SAM.Unpaired",an$Selfac,an$case,"vs",an$control,sep="_")
	out<<-list(tmp.out,tmp.name,"sam",sam.out)
	names(out)<<-c("result","name","type","outset")
	UpStage(12,"SAM.Unpaired");
});
	tkconfigure(tt,cursor="arrow");
	tkfocus(tt);
}
