SelectCaseControl<-function(NumFac=1,factor1title="Factor1",factor2title="Factor2",titlevalue="Select your factors",SecBlock=F)
{
Try({
factor1title="Factor1";factor2title="Factor2";titlevalue="Select your factors";SecBlock=F
	if(as.numeric(tclvalue(Stage))<10)
	{
		tkmessageBox(message="Please Finish the previous step!");
		tkfocus(tt);return();
	}
	tkconfigure(tt,cursor="watch")
	list.factor=colnames(data.info);
repeat {
	ans=SelectFactor(list.factor,factor1title,factor2title,titlevalue)
	SelFac=2-sum(ans=="UnSelected");
	#print(SelFac);
	if(!sum(SelFac==NumFac))
	{
		tkfocus(tt);
		tkconfigure(tt,cursor="arrow");
		tkmessageBox(message="Please select the proper number of factors!");
		return();
	}
	if(SelFac==2 & ans[1]==ans[2]) 
	{
		tkfocus(tt);
		tkconfigure(tt,cursor="arrow");
		tkmessageBox(message="Please select the different factors!");
		return();
	}
	if(ans[1]!="UnSelected" & ans[2]=="UnSelected")
	{
		Factor1=ans[1];
		Factor2=NULL;
		list.value=factor(data.info[,Factor1]);
		list.trt=levels(list.value);
	}else if(ans[1]=="UnSelected" & ans[2]!="UnSelected")
	{
		Factor1=NULL;
		Factor2=ans[2];
		list.value=factor(data.info[,Factor2]);
		list.trt=levels(list.value)
	}else{
		Factor1=ans[1];
		Factor2=ans[2];
		list.value=factor(paste(data.info[,Factor1],data.info[,Factor2],sep="."))
		if(SecBlock)
		{
			list.trt=levels(factor(data.info[,Factor1]));
		}else{
			list.trt=c(levels(factor(data.info[,Factor1])),levels(factor(data.info[,Factor2])),levels(list.value))
		}
	}

	if(length(list.trt)<=1)	
	{
	an=tkmessageBox(message="Number of Treatments should be at least 2, \nplease Choose your factor again!",type="yesno")
	if(tclvalue(an)=="no") return();
	}else{
      ######################################################################################
		ans=SelectLevels(list.trt)
		if(ans[1]=="UnSelected" | ans[2]=="UnSelected")
		{
		tkfocus(tt);
		tkconfigure(tt,cursor="arrow")
		return();
		}
		jug1=jug2=jug3=TRUE;
		if(!is.null(Factor1))
		{	
			jug1=ans[1] %in% levels(factor(data.info[,Factor1])) & ans[2] %in% levels(factor(data.info[,Factor1]));
		}
		if(!is.null(Factor2))
		{
			jug2=ans[1] %in% levels(factor(data.info[,Factor2])) & ans[2] %in% levels(factor(data.info[,Factor2]))
		}
		if(exists("Comb"))	
		{
			jug3=ans[1] %in% levels(Comb) & ans[2] %in% levels(Comb)
		}
		jug4=ans[1] != ans[2]
		if((jug1 | jug2 | jug3) & jug4)
		{
			an=tkmessageBox(message=paste("You have selected Contrast: \n",ans[1]," VS ",ans[2],sep=""),type="okcancel");
			if(tclvalue(an)=="ok") break;
		}else
		{
			an=tkmessageBox(message=paste("You have selected Contrast: \n",ans[1]," VS ",ans[2],"\n Your contrast is not comparable. \n Please Choose your contrast again!",sep=""),type="ok");
		}	
	}
}
	index.case=grepl(ans[1],list.value);
	index.control=grepl(ans[2],list.value);
	sample.sel=index.case | index.control;
	return(list(index.case=index.case,index.control=index.control,sample.sel=sample.sel,Factor1=Factor1,Factor2=Factor2,Case=ans[1],Control=ans[2]));
});
}