TimemaSigPro<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<10)
	{
		tkmessageBox(message="Please Finish the previous step!");
		tkfocus(tt);return();
	}
	tkconfigure(tt,cursor="watch")

	an=Input.TimemaSigPro();
	if(as.numeric(an$ReturnValue)!=1) {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}

	factorIndex=an$Selfac;
	TimeIndex=an$SelTime;
	RepIndex=an$SelRep;
	control=an$control;
	fdrQ=as.numeric(an$fdr);
	alfa=as.numeric(an$alfa);
	#Rcut=as.numeric(an$rsq);

	tmp.design=model.matrix(~0+data.info[,factorIndex])
	rownames(tmp.design)=data.info[,"FileName"]
	colnames(tmp.design)=levels(factor(data.info[,factorIndex]))
	index.control=match(control,colnames(tmp.design))
	tmp.order=1:length(colnames(tmp.design))
	tmp.design=tmp.design[,c(index.control,tmp.order[-index.control])]
	data.design=cbind(data.info[,TimeIndex],data.info[,RepIndex],tmp.design)
	colnames(data.design)=c("Time","Rep",colnames(tmp.design))
	design=make.design.matrix(data.design,degree=2)
	data=exprs(data.eset)[1:400,];
	fit=p.vector(data,design,Q=fdrQ,MT.adjust="BH",min.obs=3)
	if(dim(fit$SELEC)[1]==0)
	{
		tkmessageBox(title="Warning!",message="no significant genes found! \nPlease Recustomize your parameters",icon="info",type="ok")
		tkconfigure(tt,cursor="arrow");
		tkfocus(tt);
		return();
	}else{
		tkmessageBox(title="Info!",message=paste("There are ",dim(fit$SELEC)[1]," significant genes found!",sep=""),icon="info",type="ok")
	}
	tstep=T.fit(fit,step.method="two.ways.backward",alfa=alfa);
	tmp.out=as.data.frame(tstep$sol);
	tmp.out=cbind(PROBEID=rownames(tmp.out),tmp.out)
	#tmp.out=get.siggenes(tstep,rsq=Rcut,vars="groups")
#Output the result
	tmp.name=paste("maSigPro",factorIndex,"Control",control,"FDR",fdrQ,"alfa",alfa,sep="_")
	out<<-list(tmp.out,tmp.name,"timemasigpro",tstep)
	names(out)<<-c("result","name","type","outobj")
	UpStage(12,"TimemaSigPro");
});
	tkconfigure(tt,cursor="arrow");
	tkfocus(tt);
}
