DrawHeatmap<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<2)
	{
		tkmessageBox(message="Please select the project first!");
		return();
	}
	tkconfigure(tt,cursor="watch");
	an=Input.DrawHeatmap();
	if(as.numeric(an$ReturnValue)!=1) {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}

	if(an$Seltype=="From current dataset")
	{
	
		eset.sel=data.eset[ga.output$result.filtered[,"PROBEID"],];
		eset.sel=exprs(eset.sel);
		if(is.null(eset.sel)){tkmessageBox(message="Gene list is not generated!",icon="info");tkconfigure(tt,cursor="arrow");tkfocus(tt);return();} 
		num=dim(eset.sel)[1];
		if(num>100){
		jug=tkmessageBox(message=paste("There are ",num," PROBEIDs will be displayed in the graph. \nAre you sure to do this?",sep=""),
			icon="info",type="yesno");
		if(tclvalue(jug)=="no"){tkconfigure(tt,cursor="arrow");tkfocus(tt);return();} 
		}
	}else{
		gene.list=read.delim(an$f1,header=T);
		data.list=read.delim(an$f2,header=T);
		eset.sel=merge(gene.list,data.list,by="PROBEID")[,colnames(data.list)];
		rownames(eset.sel)=eset.sel[,colnames(eset.sel)=="PROBEID"]
		eset.sel=as.matrix(eset.sel[,colnames(eset.sel)!="PROBEID"]);
		num=dim(eset.sel)[1];
		if(num==0)
		{
			jug=tkmessageBox(message=paste("There are ",num," PROBEIDs found from the input files. \nNothing will be drawn.",sep=""),
			icon="info",type="yesno");
			tkconfigure(tt,cursor="arrow");tkfocus(tt);return();
		}
		if(num>100){
		jug=tkmessageBox(message=paste("There are ",num," PROBEIDs will be displayed in the graph. \nAre you sure to do this?",sep=""),
		icon="info",type="yesno");
		if(tclvalue(jug)=="no"){tkconfigure(tt,cursor="arrow");tkfocus(tt);return();} 
		}
	}
######################################################################
	path.output=paste(tclvalue(Path.project),"/Output/Heatmap",sep="");
	output_path2=path.output;
	if(!file.exists(output_path2)) dir.create(output_path2,recursive=T)
	out_names=paste("Heatmap_",num,"_PROBEIDs",sep="");
	filename=paste(path.output,"/",out_names,".pdf",sep="");
	pdf(file=filename);
	heatmap.2(eset.sel[1:num,],cexRow=0.5,cexCol=0.6,scale="row",col=redgreen(100),
	symkey=FALSE, density.info="none",trace="none");
	dev.off();
#######################################################################
	tkmessageBox(message=paste("The file has been save as: \n",filename,sep=""),icon="info",type="ok")
	tkconfigure(tt,cursor="arrow");
	tkfocus(tt);
});
}

Input.DrawHeatmap<-function()
{
OnOK <- function()
{	
	tclvalue(ReturnValue)=1
	tkgrab.release(tt.sub)
	tkdestroy(tt.sub)
	tkfocus(tt)
}
OnCancel <- function()
{	
	tkgrab.release(tt.sub)
	tkdestroy(tt.sub)
	tkfocus(tt)
}
Sel1 <- function()
{
	tkconfigure(entry1,state="disabled");
	tkconfigure(entry2,state="disabled");
}
Sel2 <- function()
{
	tkconfigure(entry1,state="normal");
	tkconfigure(entry2,state="normal");
}

ChooseF2 <- function()
{
    	file.tmp=tclvalue(tkgetOpenFile(title="Please Choose your read in output file!",filetypes="{{DEG Files} {.DEG.txt}}",initialdir="output/"))
	if(file.tmp!="") tclvalue(SelValue1)=file.tmp;
}
ChooseF3 <- function()
{ 
    	file.tmp=tclvalue(tkgetOpenFile(title="Please Choose your read in output file!",filetypes="{{Prep Files} {.Prep.txt}}",initialdir="output/"))
	if(file.tmp!="") tclvalue(SelValue2)=file.tmp;
}
#Initial panel
	tt.sub= tktoplevel(tt);
	tkwm.deiconify(tt.sub)
	tkgrab.set(tt.sub)
	tkfocus(tt.sub)
	tkwm.title(tt.sub,"Draw Heatmap")
	tmp.len=100;
	ReturnValue=tclVar(0);
#font
	font.tmp<- tkfont.create(family="times",size=12,weight="bold",slant="italic");
#Frame
	FrameMain1 <- tkframe(tt.sub)
	FrameMain2 <- tkframe(tt.sub)
#subFrame
	frame0 <- tkframe(FrameMain1,relief="groove",borderwidth=2,background="white")
	frame1 <- tkframe(FrameMain2,relief="flat",borderwidth=2)
	frame2 <- tkframe(FrameMain2,relief="flat",borderwidth=2)
#subsubFrame	
	frame1a <- tkframe(frame1,relief="flat",borderwidth=10)
	frame1b <- tkframe(frame1,relief="flat",borderwidth=10)
		frame1b.1 <- tkframe(frame1b,relief="flat",borderwidth=0)
		frame1b.2 <- tkframe(frame1b,relief="flat",borderwidth=0)
		frame1b.3 <- tkframe(frame1b,relief="flat",borderwidth=0)
		frame1b.4 <- tkframe(frame1b,relief="flat",borderwidth=0)
		frame1b.5 <- tkframe(frame1b,relief="flat",borderwidth=0)
		
#Add object
##############################################
#top
	label0=tklabel(frame0,text=" ",width=tmp.len,background="white")
	label0.1=tklabel(frame0,text="Please select the data type to draw heatmap",background="white")
# top layout
	tkgrid(label0);tkgrid(label0.1,sticky="wn");
##################################################################
#middle

	type.list=c("From current dataset", 
			"From outside file");
	type.list2=c("Heatmap input from current dataset", 
			"Heatmap input from outside file");
	label1.1=tklabel(frame1,text=" ",width=50,anchor="w")
	rbValue1 <- tclVar(type.list[2])
	rbs1=list();
 	rbs1[[1]]=tkradiobutton(frame1a, text=type.list2[1], value=type.list[1], variable=rbValue1,command=Sel1);
 	rbs1[[2]]=tkradiobutton(frame1b.1, text=type.list2[2], value=type.list[2], variable=rbValue1,command=Sel2);

	SelValue1=tclVar("*.DEG.txt");
	SelValue2=tclVar("*.Prep.txt");

	label1.2=tklabel(frame1b.2,text="Please select filtered gene list: ")
	but1.1 <-tkbutton(frame1b.3,text="Filtered file",command=ChooseF2,width=15)
	entry1 <-tkentry(frame1b.3,width="50",textvariable=SelValue1,state="normal")

	label1.3=tklabel(frame1b.4,text="Please select preprocessed file of gene list: ")
	but1.2 <-tkbutton(frame1b.5,text="Preprocess file",command=ChooseF3,width=15)
	entry2 <-tkentry(frame1b.5,width="50",textvariable=SelValue2,state="normal")

#middle layout

	tkgrid(label1.1,sticky="w");
	#tkgrid(rbs1[[1]],sticky="w");	
	#tkgrid(rbs1[[2]],sticky="w");

	tkgrid(label1.2);
	tkgrid(entry1,but1.1);

	tkgrid(label1.3);
	tkgrid(entry2,but1.2);

	tkgrid(frame1b.1,sticky="w");tkgrid(frame1b.2,sticky="w");tkgrid(frame1b.3,sticky="w");
	tkgrid(frame1b.4,sticky="w");tkgrid(frame1b.5,sticky="w");
	tkgrid(frame1a,sticky="w");	tkgrid(frame1b,sticky="w");
##################################################################
#bottom
	OK.but <-tkbutton(frame2,text="OK",command=OnOK,width=10)
	Cancel.but <-tkbutton(frame2,text="Cancel",command=OnCancel,width=10)
#bottom layout
 	tkgrid(OK.but,Cancel.but,sticky="es");
##################################################################
#layout frame
	tkgrid(frame0);
	tkgrid(frame1);
	tkgrid(frame2);
	tkgrid(FrameMain1);tkgrid(FrameMain2);
	tkfocus(tt.sub)
	tkwait.window(tt.sub)
	return(list(ReturnValue=tclvalue(ReturnValue),Seltype=tclvalue(rbValue1),f1=tclvalue(SelValue1),f2=tclvalue(SelValue2)))
}