####################### Preprocessing Data###################
Affy.Prepro<-function()
{
Try({
	#sel=SelectOne(list,title="Preprocessing method",mess="Please customize your preprocessing method:",width=50,list2=list2)
	an=Input.Affy.Prepro();
	mess="Done";
	prefix=data.raw@annotation;
	spe.list=c("hugene10stv1","mogene10stv1","ragene10stv1","huex10stv2","moex10stv1","raex10stv1")
	if(any(prefix %in% spe.list))
	{
		if(an$sel%in%c("gcrma","dchip","advanced")) 
		{
			tkmessageBox(message=paste("Preprocessing Method (",an$sel,") is not available for Chip ",prefix,sep=""))
			tkconfigure(tt,cursor="arrow");
			tkfocus(tt);
			return();
		}
	}
	if(an$ReturnValue!="1") {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}
switch(an$sel,
		"rma"={data.eset<<-rma(data.raw);mess="rma";}, #Note that this expression measure is given to you in log base 2 scale. 
	
		"gcrma"={data.eset<<-gcrma(data.raw);mess="gcrma";},#Note that this expression measure is given to you in log base 2 scale.
		
		"mas5"={data.eset<<-mas5(data.raw);mess="mas5";exprs(data.eset)<<-log2(exprs(data.eset))},
		
		"dchip"={		data.eset<<-expresso(data.raw, 
				 bg.correct=FALSE,
	                   normalize.method="invariantset",
				 pmcorrect.method="pmonly",
	                   summary.method="liwong",
				 widget = F	); mess="dchip";},
		"advanced"={
			sel=Input.Affy.AdvancePreP();
			if(sel[[1]]=="-1") {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}
			data.eset<<-expresso(data.raw, 
				 bgcorrect.method=sel[[1]],
	                   normalize.method=sel[[2]],
				 pmcorrect.method=sel[[3]],
	                   summary.method=sel[[4]],
				 widget = F	);
			mess="advanced";	
		}
	)
##############################################

	tmp=as.data.frame(exprs(data.eset));
	Label=colnames(tmp);
	Label.order=match(Label,data.info[,"FileName"])
	data.info<<-data.info[Label.order,]

	tmp=cbind(rownames(tmp),tmp);
	colnames(tmp)[1]="PROBEID";
#check whether the data matchs up:
      t1=length(Label);
	t2=sum(Label==data.info[,"FileName"])
	if(is.numeric(t1) & is.numeric(t2))
	{
		if(t1==t2){
		tkmessageBox(message="Design Table and Raw Data have matched up! \nPerforming automatic probeset annotation!")
		Affy.Anno();
		UpStage(10,mess);
		
		tmp.string=tclvalue(Path.output);
		tmp.string=gsub("\\","/",tmp.string,fixed = TRUE)
		if(substring(tmp.string,nchar(tmp.string))!="/") tmp.string=paste(tmp.string,"/",sep="")
		file.name=paste(tmp.string,gsub("_CDF","",tclvalue(UsedCDF)),".",an$sel,".Prep.txt",sep="");
		write.table(tmp,file.name,sep="\t",quote=F,row.names=F);
		tkmessageBox(message="Data Annotation Completed and Preprocessed data Saved.")
		}else{
		tkmessageBox(message="No! The data doesn't match up!")
		tclvalue(label.taskdone)="Preprocessing failed!";
		tclvalue(label.tasktodo)="Please redo the previous steps";
		}
	}
});
}
#################################################################
Lumi.Prepro<-function(type="noneprep")
{
Try({
	if(type=="noneprep")
	{
		an=Input.Lumi.Prepro();
		if(an$ReturnValue!="1") {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}
		if(an$bg!="none") {in.bg=T}else{in.bg=F}
		in.norm=T;
		if (an$norm=="vsn")
		{
		tkmessageBox(message="You selected vsn,then there will be no variance stablization!")
		in.vs=F;
		}else{
		in.vs=T
		}
		data.eset<<-lumiExpresso(data.raw,
			QC.evaluation=T,
			bg.correct=in.bg,
			bgcorrect.param=list(method=an$bg),
			normalize=in.norm,
			normalize.param=list(method=an$norm),
			variance.stabilize=in.vs,
			varianceStabilize.param=list(method=an$vs))
		tkmessageBox(message="Data Preprocessing Finished!")
	}else{
		an=Input.Lumi.Prep.Prepro();
		if(an$ReturnValue!="1") {tkconfigure(tt,cursor="arrow");tkfocus(tt);return();}
		data.eset<<-data.raw;
		tkmessageBox(message="No Preprocessing Performed!")
	}
# the order of the Sample in the data.eset should match
# the order of the SampleName in the data.info

	tmp=as.data.frame(exprs(data.eset));
	Label=colnames(tmp);
	Label.order=match(Label,data.info[,"FileName"])
	data.info<<-data.info[Label.order,]
	tmp=cbind(rownames(tmp),tmp);
	colnames(tmp)[1]="PROBEID";

#check whether the data matchs up:
      t1=length(Label);
	t2=sum(Label==data.info[,"FileName"])
	if(is.na(t1) | is.na(t2)) {tkmessageBox(message="Data Annotation Failed. Please Check your design table.");return();}
	if(t1==t2) 
	{
		tkmessageBox(message="Design Table and Raw Data have matched up! \nPerforming automatic probeset annotation!")
		data.anno<<-NULL;
		if(an$reAnno=="Re-Annotation") 
		{
			illumi.ReAnno.MD();
			Anno.name="ReAnnoBM";
		}else if(an$reAnno=="Illumima Annotation") 
			{
			Illumina.Anno();
			Anno.name="Ilmn";
		}else{
			Lumi.ReAnno.nuID();
			Anno.name="Lumi"
		}
		if(is.null(data.anno))
		{
			tkmessageBox(message="Annotation has failed! \nPlease consider other options!\n");
			Anno.name="Failed";
		}else if(dim(data.anno)[1]==0)
		{
			tkmessageBox(message="Annotation has failed! \nPlease consider other options!\n");
			Anno.name="Failed";
		}
		tmp.string=tclvalue(Path.output);
		tmp.string=gsub("\\","/",tmp.string,fixed = TRUE)
		if(substring(tmp.string,nchar(tmp.string))!="/") tmp.string=paste(tmp.string,"/",sep="")
		prep.name=paste(an$bg,an$norm,an$vs,sep="_"); 
            if(length(prep.name)==0) prep.name="None";
            file.name=paste(tmp.string,Anno.name,".",prep.name,".Prep.txt",sep="");
		write.table(tmp,file.name,sep="\t",quote=F,row.names=F);
		UpStage(10,mess2=Anno.name);
	}else{
		tkmessageBox(message="No! The data doesn't match up!")
		message("No! The data doesn't match up!")
		tclvalue(label.taskdone)="Preprocessing failed!";
		tclvalue(label.tasktodo)="Please redo the previous steps";
	}
});
}
#####################################################################################################
Prepro<-function()
{
Try({
	tkfocus(tt)
	if(as.numeric(tclvalue(Stage))<7)
	{
		tkmessageBox(message="Please Finish the previous step!");
		tkfocus(tt);return();
	}
	if(tclvalue(Data.Type)=="Affy Data(*.CEL)")
	{
		tkconfigure(tt,cursor="watch")
		Affy.Prepro();
		tkconfigure(tt,cursor="arrow")
	}else if(tclvalue(Data.Type)=="Illumina Data(non-preprocessed)") {
		tkconfigure(tt,cursor="watch")
		Lumi.Prepro("noneprep");
		tkconfigure(tt,cursor="arrow")
	}else if(tclvalue(Data.Type)=="Illumina Data(Preprocessed)") {
		tkconfigure(tt,cursor="watch")
		Lumi.Prepro("prep");
		tkconfigure(tt,cursor="arrow")
	}else{tkmessageBox(message="Please Make sure you finished the previous steps!")}
	tkfocus(tt)
});
}